/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#include <iostream>

#include "Closure.h"
#include "VMState.h"
#include "stdfuns.h"

Closure::Closure(VMState* vm, func fn, int args, int arity, bool stack):m_fn(fn)
{
//    cout << "Making closure " << (void*)(m_fn) << endl;
    m_args=(Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*arity);
    m_numargs=args;
    if (stack) {
	for(int i=0;i<args;i++) {
//	cout << "Arg" << endl;
/// Create a *new* reference, or things break in confusing ways.
	  m_args[i]=vm->doPop()->clone();
//	m_args[i]=vm->doPop();
	}
    }
}

void Closure::addArgs(VMState* vm, int added)
{
    int newnum = m_numargs+added;
    int i;

    for(i=m_numargs; i<newnum; i++) {
        m_args[i]=vm->doPop()->clone();
    }
    m_numargs = newnum;
}

Closure::~Closure()
{
    GC_FREE(m_args);
}

void Closure::run(VMState* vm)
{
    for(int i=m_numargs;i>0;i--) {
	vm->push(m_args[i-1]);
    }
    m_fn(vm);
}

bool Closure::eq(Closure* c)
{
    if (getFnID()!=c->getFnID()) { return false; }
    if (m_numargs!=c->m_numargs) { return false; }

    for(int i=0;i<m_numargs;i++)
    {
	if (!funtable_eq(NULL,m_args[i],c->m_args[i])) { return false; }
    }
    return true;

}

Closure* Closure::copy(map<Value*, Value*>& done)
{
    // FIXME: This ought to clone the arguments to be a proper copy
    return this;
}
