#include <iostream>

#include "regex_glue.h"
#include "Heap.h"
#include "VM.h"

void* re_compile(wchar_t* pattern, kint flagcode)
{
    const char* error;
    int erroffset;
    int regexflags = 0;
    if (flagcode & 1) { regexflags = regexflags | PCRE_CASELESS; }
    if (flagcode & 2) { regexflags = regexflags | PCRE_EXTENDED; }
    if (flagcode & 4) { regexflags = regexflags | PCRE_MULTILINE; }
    if (flagcode & 8) { regexflags = regexflags | PCRE_UNGREEDY; }
    pcre* re =  pcre_compile(wctostr(pattern),regexflags,&error, &erroffset, NULL);
    return (void*)re;
}

void* re_match(void* pc, wchar_t* wstr)
{
  char* str = wctostr(wstr);
    int ovector[255];
    Match* m = new Match();

    pcre* re = (pcre*)pc;
    int rc = pcre_exec(re, NULL, str, strlen(str), 0, 0, ovector, 255);
    int len = strlen(str);

//    cout << rc << endl;

    if (rc>=0) {
	m->matched = true;
	m->matches = new Array();

	m->before = (wchar_t*)GC_MALLOC((ovector[0]+1)*sizeof(wchar_t));
	wcsncpy(m->before, strtowc(str),ovector[0]);
	m->before[ovector[0]]='\0';

	int afterlen = len-ovector[1];
	m->after = (wchar_t*)GC_MALLOC((afterlen+1)*sizeof(wchar_t));
	wcsncpy(m->after, strtowc(str+ovector[1]),afterlen);
	m->after[afterlen]='\0';

	for(int i=0;i<rc;i++) {
//	    cout << ovector[i*2] << "-" << ovector[i*2+1] << endl;
	    const char* sub;
	    pcre_get_substring(str, ovector, rc, i, &sub);
	    char* val = (char*)GC_MALLOC((strlen(sub)+1)*sizeof(char));
	    strcpy(val,sub);
	    // this should really use the API!
	    m->matches->push_back(new Value(new String(strtowc(val)),KVT_STRING));
	}
    }
    else
    {
	m->matched = false;
	m->matches = new Array();
    }
    return (void*)m;
}

Array* getmatches(void* mo)
{
    return ((Match*)mo)->matches;
}

bool matched(void* mo)
{
    return ((Match*)mo)->matched;
}

wchar_t* getBefore(void* mo)
{
    return ((Match*)mo)->before;    
}

wchar_t* getAfter(void* mo)
{
    return ((Match*)mo)->after;    
}
