/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __KZ_STATUSBAR_H__
#define __KZ_STATUSBAR_H__

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_STATUSBAR		(kz_statusbar_get_type ())
#define KZ_STATUSBAR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_STATUSBAR, KzStatusbar))
#define KZ_STATUSBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_STATUSBAR, KzStatusbarClass))
#define KZ_IS_STATUSBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_STATUSBAR))
#define KZ_IS_STATUSBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_STATUSBAR))
#define KZ_STATUSBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_STATUSBAR, KzStatusbarClass))

typedef struct _KzStatusbar      KzStatusbar;
typedef struct _KzStatusbarClass KzStatusbarClass;

struct _KzStatusbar
{
	GtkHBox parent;
};

struct _KzStatusbarClass
{
	GtkHBoxClass parent_class;
};

GType      kz_statusbar_get_type          (void) G_GNUC_CONST;
GtkWidget *kz_statusbar_new               (KzWindow *kz);

void       kz_statusbar_set_text         (KzStatusbar *bar, const gchar *text,
					  guint id);
void       kz_statusbar_set_text_with_name (KzStatusbar *bar, const gchar *text,
					    const gchar *name);
void       kz_statusbar_set_link_text    (KzStatusbar *bar, const gchar *text);
void       kz_statusbar_set_gesture_text (KzStatusbar *bar, const gchar *text);
void       kz_statusbar_set_copied_text (KzStatusbar *bar, const gchar *text);

void       kz_statusbar_set_focus_to_find_area (KzStatusbar *bar);

G_END_DECLS

#endif /* __KZ_STATUSBAR_H__ */
