#! /bin/sh

color_ok="\\033[1;32m"
color_error="\\033[1;31m"
color_normal="\\033[0;39m"


prog_action(){
	echo
	echo -e "$color_ok $@ $color_normal"
}

prog_err(){
	echo
	echo -e "$color_error ERROR doing $@ $color_normal"
}

export UNSERMAKE=no
export PATH=$PATH:/usr/local/bin:/usr/local/gnu-autotools/bin

UNAME_SYSTEM=`(uname -s) 2>/dev/null`  || UNAME_SYSTEM=unknown

case "${UNAME_SYSTEM}" in
    *BSD*)
	prog_action "Doing libtoolize..."
	libtoolize -f -c
	;;
    *)
	;;
esac

prog_action "Doing automake/autoconf..."
make -f Makefile.cvs
[ $? -ne 0 ] && prog_err "automake/autoconf..." && exit 1

prog_action "Doing configure..."
./configure --prefix=`kde-config --prefix`
[ $? -ne 0 ] &&  prog_err "configure..." && exit 1

prog_action "Doing make..."
make
[ $? -ne 0 ] && prog_err "make..." && exit 1

prog_action "Success building KBFX..."

prog_action "Now you can run 'su' and 'make install' to install KBFX..."
