/******************************************************************************
 *   Copyright (C) 2005 Siraj Razick <siraj@kdemail.net>                      *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#include "kbfxconfig.h"
#include <qfileinfo.h>

KbfxConfig::KbfxConfig()
{
  /* set default configuration values */
  QString path = locate ("data", "kbfx/skins/default/bg.png");
  path.remove("default/bg.png");

  kdDebug() << "Configuration path skins: " + path << endl;

  m_KbfxGeneralVersionDefault = "NONE";
  m_KbfxNormalButtonPathDefault = path + "default/normal.png";
  m_KbfxHoverButtonPathDefault = path + "default/hover.png";
  m_KbfxPressedButtonPathDefault = path + "default/pressed.png";
  m_KbfxMenuTypeDefault = "spinx";
  

  m_SpinxThemeBasePathDefault = path;
  m_UserSpinxThemeBasePathDefault = path;
  m_SpinxDudeBlinkDefault = FALSE;
  m_SpinxThemeNameDefault = "default";
//  m_ToolBarResizeDefault = TRUE;
  m_ToolBarResizeDefault = FALSE;

  KUser *user = new KUser();
  m_SpinxDudeImageDefault = locate("data", user->homeDir () + "/.face.icon");
  if (m_SpinxDudeImageDefault == QString::null || !KStandardDirs::exists(m_SpinxDudeImageDefault))
  {
    m_SpinxDudeImageDefault = locate("data","kbfx/skins/default/menu_top_image_person.png");
  }

  m_ToolTipDefault = TRUE;
  m_ToolTipAnimationDefault = TRUE;
  m_ToolTipTextDefault = "Application menu";

  m_ToolTipAvatarDefault = path + "default/butterfly.png";

  m_KbfxHistoryDefault = "";
  
  m_plugins="System";

  /* layout */
  m_facePos_x = 4;
  m_facePos_y = 4;
  m_userNamePos_x  = 51 + 16;
  m_userNamePos_y = 16;
  m_faceBoxHideText = FALSE;

  m_topBar_x = 0;
  m_topBar_y = 0;
  m_topBar_h = 58;
  m_topBar_w = 373;

  m_botBar_x = 0;
  m_botBar_y = 330;
  m_botBar_h = 36;
  m_botBar_w = 373;

  m_scrollBarBotY = 319;
  m_scrollBarBotX = 107;

  m_scrollBarTopX = 107;
  m_scrollBarTopY = 58;

  m_listBox_x = 0;
  m_listBox_y = m_topBar_h;
  m_listBox_w = 106;
  m_listBox_h = 275;

  m_searchBox_h = 22;
  m_searchBox_w = 270;
  m_searchBox_x = 80;
  m_searchBox_y = 48-22;
  m_searchBox_static = TRUE;

  m_itemView_h = 248;
  m_itemView_w = 200;
  m_itemView_x = 107;
  m_itemView_y = 58 + 12;

  m_enableWater = FALSE;
  m_waterRate = 0;

  /* toolbar */
  m_toolBarButtonNormalSize = 48;
  m_toolBarButtonExpandSize = 48;

  m_KbfxGlobalChange = FALSE;

  read();
}

KbfxConfig& ConfigInit()
{
  static KbfxConfig _config;

  return _config;
}

void KbfxConfig::setDefault()
{
  /* set default configuration */
  m_KbfxNormalButtonPath = m_KbfxNormalButtonPathDefault;
  m_KbfxHoverButtonPath = m_KbfxHoverButtonPathDefault;
  m_KbfxPressedButtonPath = m_KbfxPressedButtonPathDefault;
  m_KbfxMenuType = m_KbfxMenuTypeDefault;

  m_SpinxThemeBasePath = m_SpinxThemeBasePathDefault;
  m_UserSpinxThemeBasePath = m_UserSpinxThemeBasePathDefault;
  m_SpinxDudeBlink = m_SpinxDudeBlinkDefault;
  m_SpinxDudeImage = m_SpinxDudeImageDefault;
  m_SpinxThemeName = m_SpinxThemeNameDefault;
  m_ToolBarResize = m_ToolBarResizeDefault;

  m_ToolTip = m_ToolTipDefault;
  m_ToolTipAnimation = m_ToolTipAnimationDefault;
  m_ToolTipText = m_ToolTipTextDefault;
  m_ToolTipAvatar = m_ToolTipAvatarDefault;

  m_KbfxHistory = m_KbfxHistoryDefault;

  m_fontAppNameColor = m_fontAppNameColorDefault;
  m_fontAppCommentColor = m_fontAppCommentColorDefault;
  m_lineColor = m_lineColorDefault;
  m_fontIndexColor = m_fontIndexColorDefault;
  m_fontSize = m_fontSizeDefault;
  m_userNameColor = m_userNameColorDefault;
  m_plugins = "System";

  /* layout */
  m_facePos_x = 4;
  m_facePos_y = 4;
  m_userNamePos_x = m_facePos_x + 16;
  m_userNamePos_y = 16;

  m_topBar_x = 0;
  m_topBar_y = 0;
  m_topBar_h = 156;
  m_topBar_w = 365;

  m_listBox_x = 160;
  m_listBox_y = 0;
  m_listBox_w = 102;
  m_listBox_h = 200;

  m_searchBox_h = 22;
  m_searchBox_w = 175;
  m_searchBox_x = m_listBox_w;
}

void KbfxConfig::setFontsDefault()
{
  /* set default fonts values */
  m_fontAppNameColorDefault = QColor(0,0,0);
  m_fontAppCommentColorDefault = QColor(128,125,0);
  m_lineColorDefault = QColor(255,220,125);
  m_fontIndexColorDefault = QColor(0,0,0);
  m_fontSizeDefault = 8;
  m_userNameColorDefault = QColor(255,255,255);
  m_sepNameColorDefault = QColor(0,0,0);
}

void KbfxConfig::read()
{
  /* read configuration */
  if(confskel !=0) delete confskel;

  confskel = new KConfigSkeleton(QString::fromLatin1("kbfxrc"));

  KConfig *conf = confskel->config();

  QString __default = KGlobal::iconLoader()->iconPath("kbfx", (int)KIcon::Desktop, FALSE);

  conf->setGroup("KbfxGeneral");
  m_KbfxGeneralVersion = conf->readEntry ("Version", m_KbfxGeneralVersionDefault);
  
  conf->setGroup("KbfxButton");
  if (m_KbfxGeneralVersion == "NONE")
  {
	m_KbfxNormalButtonPath = m_KbfxNormalButtonPathDefault;
	m_KbfxHoverButtonPath = m_KbfxHoverButtonPathDefault;
	m_KbfxPressedButtonPath = m_KbfxPressedButtonPathDefault;
  }
  else
  {
	m_KbfxNormalButtonPath = conf->readEntry ("Normal", m_KbfxNormalButtonPathDefault);
	m_KbfxHoverButtonPath = conf->readEntry ("Hover", m_KbfxHoverButtonPathDefault);
	m_KbfxPressedButtonPath = conf->readEntry ("Press", m_KbfxPressedButtonPathDefault);
  }
  m_KbfxMenuType = conf->readEntry("MenuType", m_KbfxMenuTypeDefault);
  m_ToolBarResize = conf->readBoolEntry("ToolBarResize", m_ToolBarResizeDefault);

  conf->setGroup("SpinxBar");
  if (m_KbfxGeneralVersion == "NONE")
  {
	m_SpinxThemeBasePath = m_SpinxThemeBasePathDefault;
	m_SpinxThemeName = m_SpinxThemeNameDefault;
	m_SpinxDudeImage = m_SpinxDudeImageDefault;
  }
  else
  {
	m_SpinxThemeBasePath = conf->readEntry("ThemePath", m_SpinxThemeBasePathDefault);
	m_SpinxThemeName = conf->readEntry("ThemeName", m_SpinxThemeNameDefault);
	m_SpinxDudeImage = conf->readEntry("DudeImage", m_SpinxDudeImageDefault);
  }
  m_UserSpinxThemeBasePath = conf->readEntry("UserThemePath", m_UserSpinxThemeBasePathDefault);
  m_SpinxDudeBlink = conf->readBoolEntry("DudeBlink", m_SpinxDudeBlinkDefault);

  conf->setGroup("ToolTip");
  if (m_KbfxGeneralVersion == "NONE")
  {
	m_ToolTipAvatar = m_ToolTipAvatarDefault;
  }
  else
  {
	m_ToolTipAvatar = conf->readEntry("ToolTipAvatar", m_ToolTipAvatarDefault);
  }
  m_ToolTip = conf->readBoolEntry("EnableToolTip", m_ToolTipDefault);
  m_ToolTipAnimation = conf->readBoolEntry("AnimatedTooltip", m_ToolTipAnimationDefault);
  m_ToolTipText = conf->readEntry("ToolTipText", m_ToolTipTextDefault);

  conf->setGroup("runtime");
  m_KbfxHistory = conf->readEntry("History", m_KbfxHistoryDefault);
  m_KbfxHistoryCompletion = conf->readListEntry("HistoryCompletion");

  conf->setGroup("Plugins");
  m_plugins = conf->readListEntry("LoadedPlugins", m_plugins);

  /* get some layout settings from theme layout file
   * TODO should be moved separately like font settings
   */
  QFileInfo *info = new QFileInfo(m_SpinxThemeBasePath + "/" + m_SpinxThemeName + "/kbfxlayoutrc");
  KConfig *layoutconfig = 0;

  if(info->exists() == TRUE)
    layoutconfig = new KConfig(m_SpinxThemeBasePath + "/" + m_SpinxThemeName + "/kbfxlayoutrc");
  else
    layoutconfig = new KConfig(m_SpinxThemeBasePathDefault + "/" + m_SpinxThemeNameDefault + "/kbfxlayoutrc");

  layoutconfig->setGroup("ListBox");
  m_listBox_h = layoutconfig->readNumEntry("height", m_listBox_h);
  m_listBox_w = layoutconfig->readNumEntry("width", m_listBox_w);
  m_listBox_x = layoutconfig->readNumEntry("x", m_listBox_x);
  m_listBox_y = layoutconfig->readNumEntry("y", m_listBox_y);

  layoutconfig->setGroup("TopBar");
  m_topBar_h = layoutconfig->readNumEntry("height", m_topBar_h);
  m_topBar_w = layoutconfig->readNumEntry("width", m_topBar_w);
  m_topBar_x = layoutconfig->readNumEntry("x", m_topBar_x);
  m_topBar_y = layoutconfig->readNumEntry("y", m_topBar_y);
  m_facePos_x = layoutconfig->readNumEntry("DudeX", m_facePos_x);
  m_facePos_y = layoutconfig->readNumEntry("DudeY", m_facePos_y);
  m_userNamePos_x = layoutconfig->readNumEntry("UserNameX", m_userNamePos_x);
  m_userNamePos_y = layoutconfig->readNumEntry("UserNameY", m_userNamePos_y);
  m_faceBoxHideText= layoutconfig->readBoolEntry("disableUserName", FALSE);

  layoutconfig->setGroup("BotBar");
  m_botBar_h = layoutconfig->readNumEntry("height", m_botBar_h);
  m_botBar_w = layoutconfig->readNumEntry("width", m_botBar_w);
  m_botBar_x = layoutconfig->readNumEntry("x", m_botBar_x);
  m_botBar_y = layoutconfig->readNumEntry("y", m_botBar_y);

  layoutconfig->setGroup("Scrollbars");
  m_scrollBarBotX = layoutconfig->readNumEntry("ScrollBarBotX", m_scrollBarBotX);
  m_scrollBarBotY = layoutconfig->readNumEntry("ScrollBarBotY", m_scrollBarBotY);
  m_scrollBarTopX = layoutconfig->readNumEntry("ScrollBarTopX", m_scrollBarTopX);
  m_scrollBarTopY = layoutconfig->readNumEntry("ScrollBarTopY", m_scrollBarTopY);

  layoutconfig->setGroup("MainView");
  m_itemView_h = layoutconfig->readNumEntry("height", m_itemView_h);
  m_itemView_w = layoutconfig->readNumEntry("width", m_itemView_w);
  m_itemView_x = layoutconfig->readNumEntry("x", m_itemView_x);
  m_itemView_y = layoutconfig->readNumEntry("y", m_itemView_y);

  layoutconfig->setGroup("SearchBox");
  m_searchBox_h = layoutconfig->readNumEntry("height", m_searchBox_h);
  m_searchBox_w = layoutconfig->readNumEntry("width", m_searchBox_w);
  m_searchBox_x = layoutconfig->readNumEntry("x", m_searchBox_x);
  m_searchBox_y = layoutconfig->readNumEntry("y", m_searchBox_y);
  m_searchBox_static = layoutconfig->readBoolEntry("FixedPos", TRUE);

  layoutconfig->setGroup("Water");
  m_enableWater = layoutconfig->readBoolEntry("EnableWater", FALSE);
  m_waterRate = layoutconfig->readNumEntry("FrameRate", 0);

  delete layoutconfig;

  readFontrc(m_SpinxThemeBasePath, m_SpinxThemeName);
  
  if (m_KbfxGeneralVersion == "NONE") m_KbfxGeneralVersion = VERSION; 
}

void KbfxConfig::readFontrc(QString & themePath, QString & themeName)
{
  setFontsDefault();

  /* get some font settings from theme file or from theme section */
  QFileInfo * info = new QFileInfo(themePath + "/" + themeName + "/kbfxfontrc");
  KConfig * fontconfig = 0;

  /* if theme kbfxfontrc exists, make its configuration as default values */
  if(info->exists() == TRUE)
  {
    fontconfig = new KConfig(themePath + "/" + themeName + "/kbfxfontrc");

    fontconfig->setGroup("Fonts");
    m_fontAppNameColorDefault = fontconfig->readColorEntry("ApplicationText", &m_fontAppNameColorDefault);
    m_fontAppCommentColorDefault = fontconfig->readColorEntry("CommentText", &m_fontAppCommentColorDefault);
    m_lineColorDefault = fontconfig->readColorEntry("LineColor", &m_lineColorDefault);
    m_fontIndexColorDefault = fontconfig->readColorEntry("GroupText", &m_fontIndexColorDefault);
    m_fontSizeDefault = fontconfig->readNumEntry("FontSize", m_fontSizeDefault);
    m_userNameColorDefault = fontconfig->readColorEntry("UserName", &m_userNameColorDefault);
    m_sepNameColorDefault = fontconfig->readColorEntry("SeparatorColor", &m_sepNameColorDefault);

    kdDebug() << "Read default font settings for theme "
              << themeName
              << " from file "
              << themePath
              << "/"
              << themeName
              << "/kbfxfontrc"
              << endl;

  /* kdDebug() << "Values read from file:" << endl
   *           << m_fontAppNameColorDefault << endl
   *           << m_fontAppCommentColorDefault << endl
   *           << m_lineColorDefault << endl
   *           << m_fontIndexColorDefault << endl
   *           << m_fontSizeDefault << endl
   *           << m_userNameColorDefault << endl;
   */
  }

  mainconfskel = new KConfigSkeleton(QString::fromLatin1("kbfxrc"));

  KConfig *mainconf = mainconfskel->config();

  if (m_KbfxGeneralVersion == "NONE")
  {
	m_fontAppNameColor = m_fontAppNameColorDefault;
	m_fontAppCommentColor = m_fontAppCommentColorDefault;
	m_lineColor = m_lineColorDefault;
	m_fontIndexColor = m_fontIndexColorDefault;
	m_fontSize = m_fontSizeDefault;
	m_userNameColor = m_userNameColorDefault;
	m_sepNameColor = m_sepNameColorDefault;
  }
  else
  {
	mainconf->setGroup("Theme_" + themeName);
	m_fontAppNameColor = mainconf->readColorEntry("ApplicationText", &m_fontAppNameColorDefault);
	m_fontAppCommentColor = mainconf->readColorEntry("CommentText", &m_fontAppCommentColorDefault);
	m_lineColor = mainconf->readColorEntry("LineColor", &m_lineColorDefault);
	m_fontIndexColor = mainconf->readColorEntry("GroupText", &m_fontIndexColorDefault);
	m_fontSize = mainconf->readNumEntry("FontSize", m_fontSizeDefault);
	m_userNameColor = mainconf->readColorEntry("UserName", &m_userNameColorDefault);
	m_sepNameColor = mainconf->readColorEntry("SeparatorColor", &m_sepNameColorDefault);
  }
  /* kdDebug() << "Values read from kbfxrc:" << endl
   *           << m_fontAppNameColor << endl
   *           << m_fontAppCommentColorDefault << endl
   *           << m_lineColor << endl
   *           << m_fontIndexColor << endl
   *           << m_fontSize << endl
   *           << m_userNameColor<< endl;
   */

  delete mainconfskel;
  delete fontconfig;
}

void KbfxConfig::write()
{
  KConfigSkeleton *confskel = new KConfigSkeleton(QString::fromLatin1("kbfxrc"));

  /* write configuration options */
  KConfig *conf = confskel->config();

  conf->setGroup("KDE Action Restrictions");
  conf->writeEntry("warn_unwritable_config", FALSE);

  conf->setGroup("KbfxGeneral");
  conf->writeEntry("Version", m_KbfxGeneralVersion);
  
  conf->setGroup("KbfxButton");
  conf->writeEntry("Normal", m_KbfxNormalButtonPath);
  conf->writeEntry("Hover", m_KbfxHoverButtonPath);
  conf->writeEntry("Press",  m_KbfxPressedButtonPath);
  conf->writeEntry("MenuType", m_KbfxMenuType);
  conf->writeEntry("ToolBarResize", m_ToolBarResize);


  conf->setGroup("SpinxBar");
  conf->writeEntry("ThemePath", m_SpinxThemeBasePath);
  conf->writeEntry("UserThemePath", m_UserSpinxThemeBasePath);
  conf->writeEntry("DudeBlink", m_SpinxDudeBlink);
  conf->writeEntry("DudeImage", m_SpinxDudeImage);
  conf->writeEntry("ThemeName", m_SpinxThemeName);

  conf->setGroup("ToolTip");
  conf->writeEntry("AnimatedTooltip", m_ToolTipAnimation);
  conf->writeEntry("EnableToolTip", m_ToolTip);
  conf->writeEntry("ToolTipText", m_ToolTipText);
  conf->writeEntry("ToolTipAvatar", m_ToolTipAvatar);

  conf->setGroup("runtime");
  conf->writeEntry("History", m_KbfxHistory);
  conf->writeEntry("HistoryCompletion", m_KbfxHistoryCompletion);

  conf->sync();

  delete confskel;
}

void KbfxConfig::writeFontrc(QString & themeName)
{
  /* write fonts configuration from theme name */
  mainconfskel = new KConfigSkeleton(QString::fromLatin1("kbfxrc"));

  KConfig *mainconf = mainconfskel->config();

  mainconf->setGroup("Theme_" + themeName);
  mainconf->writeEntry("ApplicationText", m_fontAppNameColor);
  mainconf->writeEntry("CommentText", m_fontAppCommentColor);
  mainconf->writeEntry("LineColor", m_lineColor);
  mainconf->writeEntry("GroupText", m_fontIndexColor);
  mainconf->writeEntry("FontSize", m_fontSize);
  mainconf->writeEntry("UserName", m_userNameColor);
  mainconf->writeEntry("SeparatorColor", m_sepNameColor);
  mainconf->sync();

  delete mainconfskel;
}

void KbfxConfig::setNormalButtonPath(QString path)
{
  if(!path.isNull()) m_KbfxNormalButtonPath = path;
}

void KbfxConfig::setHoverButtonPath(QString path)
{
  if(!path.isNull()) m_KbfxHoverButtonPath = path;
}

void KbfxConfig::setPressedButtonPath(QString path)
{
  if(!path.isNull()) m_KbfxHoverButtonPath = path;
}
