/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/






#ifndef KBFXVISTA_H
#define KBFXVISTA_H

#include "kbfxtooltip.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <qcursor.h>
#include <kglobal.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>
#include <kglobalsettings.h>
#include <qdir.h>
#include <qfile.h>
#include <ksimpleconfig.h>
#include <qdragobject.h>
//#include "settings.h"
//#include "kbfxvista.h"
#include <qtimer.h>

#include <kpanelapplet.h>
#include <qstring.h>
#include <kconfig.h>
#include <qlabel.h>
#include "kbfx_vista_button.h"
#include "vistabar.h"
#include <qevent.h>
#include <dcopclient.h>
#include <dcopobject.h>
#include <qdesktopwidget.h>
#include <kpopupmenu.h>
#include <qtabwidget.h>
#include <qheader.h>


class kbfxvista : public KPanelApplet, public DCOPObject 
{
K_DCOP
Q_OBJECT
    
public:
   kbfxvista(const QString& configFile, Type t = Normal, int actions = 0,
        QWidget *parent = 0, const char *name = 0);
    /** destructor */
    ~kbfxvista();
    
    virtual int widthForHeight(int height) const;
    virtual int heightForWidth(int width) const;
    virtual void about();
    virtual void help();
    virtual void preferences();
    void showStartMenu(void);
    void dropEvent(QDropEvent *e);
    void dragEnterEvent( QDragEnterEvent *e );
    void kbfxpop(QPoint);
    void statickbfxpop();
    void showKmenu();
    void showToolTip();
    QPoint menupos(void);
k_dcop:
	 ASYNC showMenu() ;
	 ASYNC showKbfxMenu(QPoint x);
	 ASYNC notifyConfigChange();

signals:
    void enter(void);
    void leave(void);
    void clicked(void);
    void releaseed(void);

public slots:
	void menuInit();
	void delayedLeave();
        void reajust();
	void resetButton();
protected:
void resizeEvent(QResizeEvent *);
bool eventFilter (QObject *, QEvent * e);
/*virtual bool process(const QCString & function,const QByteArray &data ,
		 QCString &reply_type, QByteArray &reply_data);
*/
private:
    KConfig *ksConfig;
    QWidget *mainView;

   /* Use only Widget needed for the applet.. */
 	kbfx_vista_button * button;
   	short int wait_dcop;
   	DCOPClient * dcop;
        QString dropedSkin; 
	QString tooltip; 
	bool blocked;
	bool fx_on;
	bool firstload;
	bool kicker_auto_ajust;
	QString bartype;
        void chooseBarType(void);	
	void dropSkin(QDropEvent *e);
	void setSkin(QPixmap map);
	void popinit(void);
/* vista bar stuff */

    vista * a ;     
    KPopupMenu * menu;
   
/* pix map skin files */
	QString skin;
	QString skin_pressed;
	QString skin_hover;
	
/* config file */

void readConfig();
void saveConfig();

	/* paths */

	QString config;
	QString path;
	QString theme;
	QString default_theme;
	bool m_tooltip;
	bool m_spinxMenuDone;
/* i came, I saw I */bool _clicked; //hehe
/* appbar fixes */
/* custom menu */

};


#endif
