package org.kde.koala;
import org.kde.qt.*;


/** Override these methods in subclasses of {@link KDateInternalMonthPicker} to customise event handling behaviour */
public interface KDateInternalMonthPickerEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/**  Catch mouse click and move events to paint a rectangle around the item.
*/
	void mousePressEvent(QMouseEvent e);
	void customEvent(QCustomEvent arg1);

/**  Emit monthSelected(int) when a cell has been released. 
*/
	void mouseReleaseEvent(QMouseEvent e);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent e);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);

/**  The resize event. 
*/
	void resizeEvent(QResizeEvent arg1);
}

