/***************************************************************************
                            KDockTabBar.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The actual tab bar for dockwidgets  (and member of the dockwidget class set). 

 This class is covered by its manager, {@link KDockTabCtl}.
 It provides some set/get methods and managment
 methods like insert, remove, activate for tab widgets.

 See {@link KDockTabBarSignals} for signals emitted by KDockTabBar.

 See {@link KDockTabBarEventHandling} for event handlers to override in subclasses of KDockTabBar.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 The actual tab bar for dockwidgets  (and member of the dockwidget class set).
*/
public class KDockTabBar extends QWidget  {
	protected KDockTabBar(Class dummy){super((Class) null);}


/** 
 Constructs a tab bar widget.
 The parent and name argument are sent to the QWidget constructor.
   
*/
	private native void newKDockTabBar( QWidget parent, String name);
	public KDockTabBar( QWidget parent, String name) {
		super((Class) null);
		newKDockTabBar( parent, name);
	}
	private native void newKDockTabBar();
	public KDockTabBar() {
		super((Class) null);
		newKDockTabBar();
	}

/** 
 Destructs this.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Set the position to tabpos and repaints this.

*/
	public native void setTabPos( int tabpos);

/** 
 Insert a new empty tab page to the tab bar.

 If <code>id</code> is not specified, the tab is simply added. Otherwise
 it's inserted at the specified position.

*/
	public native int insertTab( String label, int identifier, int index);
	public native int insertTab( String label);

/** 
 Set an icon for the tab page with that <code>id.</code>

*/
	public native void setPixmap( int identifier, QPixmap pix);

/** 
 Set a tooltip for the tab page with that <code>id.</code>

*/
	public native void setToolTip( int identifier, String toolTipStr);

/** 
 Set the text colour for the tab page with that <code>id.</code>

*/
	public native void setTextColor( int identifier, QColor color);

/** 
 Retrieve the text colour for the tab page with that <code>id.</code>

*/
	public native QColor textColor( int identifier);

/** 
 Removes the tab page with that <code>id.</code>

*/
	public native void removeTab( int identifier);

/** 
 Retrieve the current tab page.

*/
	public native int currentTab();

/** 
 Set the current tab page to the page with that <code>id.</code>

*/
	public native void setCurrentTab( int identifier, boolean allowDisable);
	public native void setCurrentTab( int identifier);

/** 
 Enable or disable the tab page with that <code>id.</code>
   
*/
	public native void setTabEnabled( int identifier, boolean e);

/** 
 Returns if the tab page with that <code>id</code> is enabled or disabled.
   
*/
	public native boolean isTabEnabled( int identifier);

/** 
 Set the title of the tab page with that <code>id.</code>

*/
	public native void setTabCaption( int identifier, String caption);

/** 
 Retrieve the title of the tab page with that <code>id.</code>

*/
	public native String tabCaption( int identifier);

/** 
 Calls {@link QWidget#show} and {@link #showPage} for the current tab
  page, additionally.
   
*/
	public native void show();

/** 
 Set the font of <code>this.</code>
   
*/
	public native void setFont( QFont arg1);

/** 
 Show or hide the icons for the tab pages in the header.
   
*/
	public native void showTabIcon( boolean arg1);

/** 
 Returns if the icons for the tab pages are shown in the header.
   
*/
	public native boolean isShowTabIcon();

/** 
 Does things that should be done if someone has clicked the left mouse button.
   
*/
	protected native void leftClicked();

/** 
 Does things that should be done if someone has clicked the right mouse button.
   
*/
	protected native void rightClicked();
	public static final int TAB_TOP = 0;
	public static final int TAB_RIGHT = 1;
}
