/***************************************************************************
                            KServiceGroup.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is typically used like this: 

 // Lookup screensaver group
 KServiceGroup.Ptr group = KServiceGroup.baseGroup("screensavers");
 if (!group || !group.isValid()) return;

 KServiceGroup.List list = group.entries();

 // Iterate over all entries in the group
 for( KServiceGroup.List.ConstIterator it = list.begin();
      it != list.end(); it++)
 {
    KSycocaEntry p = (it);
    if (p.isType(KST_KService))
    {
       KService s = static_cast<KService >(p);
       printf("Name = %s\n", s.name().latin1());
    }
    else if (p.isType(KST_KServiceGroup))
    {
       KServiceGroup g = static_cast<KServiceGroup >(p);
       // Sub group ...
    }
 }
 
 @short 
 This class is typically used like this: 

*/
public class KServiceGroup extends KSycocaEntry  {
	protected KServiceGroup(Class dummy){super((Class) null);}


/** 
 Construct a service and take all informations from a config file

*/
	private native void newKServiceGroup( String _fullpath, String _relpath);
	public KServiceGroup( String _fullpath, String _relpath) {
		super((Class) null);
		newKServiceGroup( _fullpath, _relpath);
	}

/** 

 The stream must already be positionned at the correct offset
   
*/
	private native void newKServiceGroup( QDataStream _str, int offset, boolean deep);
	public KServiceGroup( QDataStream _str, int offset, boolean deep) {
		super((Class) null);
		newKServiceGroup( _str, offset, deep);
	}
	protected native void finalize() throws InternalError;

/** 

*/
	public native boolean isValid();

/** 
 Name used for indexing.
   
*/
	public native String name();
	public native String relPath();

/** 

*/
	public native String caption();

/** 

*/
	public native String icon();

/** 

*/
	public native String comment();

/** 

*/
	public native int childCount();

/** 

 Load the service from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 

 Save the service to a stream.
   
*/
	public native void save( QDataStream arg1);

/** 
 List of all Services and ServiceGroups within this
 ServiceGroup

*/
	public native List entries( boolean sorted, boolean excludeNoDisplay);

/** 
 As above with excludeNoDisplay true.
   
*/
	public native List entries( boolean sorted);
	public native List entries();

/** 

 The base group is defined by the X-KDE-BaseGroup key
 in the .directory file.
   
*/
	public native String baseGroupName();

/** 

*/
	public static native int baseGroup( String baseGroupName);
	public static native int root();
	public static native int group( String relPath);

/** 

 Add a service to this group
   
*/
	protected native void addEntry( KSycocaEntry entry);
}
