/***************************************************************************
                            KStyle.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Extends the {@link QStyle} class with virtual methods to draw KDE widgets.

 To create a new {@link KStyle}, reimplement the virtual functions which draw
  the GUI elements.

 See {@link KStyleSignals} for signals emitted by KStyle.

 See {@link KStyleEventHandling} for event handlers to override in subclasses of KStyle.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short 
 Extends the @ref QStyle class with virtual methods to draw KDE widgets.
*/
public class KStyle extends QPlatinumStyle  {
	protected KStyle(Class dummy){super((Class) null);}

	private native void newKStyle();
	public KStyle() {
		super((Class) null);
		newKStyle();
	}

/** 
 Draw a toolbar (without buttons, etc.)

 <code>x</code>, <code>y</code>, <code>w</code>, and <code>h</code> tell in which rectangle to draw the toolbar.

*/
	public native void drawKToolBar( QPainter p, int x, int y, int w, int h, QColorGroup g, int type, QBrush fill);
	public native void drawKToolBar( QPainter p, int x, int y, int w, int h, QColorGroup g, int type);

/** 
 Draw a toolbar handle. 

*/
	public native void drawKBarHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, int type, QBrush fill);
	public native void drawKBarHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, int type);

/** 
 Draw a toolbar button.

*/
	public native void drawKToolBarButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, boolean raised, boolean enabled, boolean popup, int icontext, String btext, QPixmap icon, QFont font, QWidget btn);
	public native void drawKToolBarButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw a menubar (without menus).

*/
	public native void drawKMenuBar( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean macMode, QBrush fill);
	public native void drawKMenuBar( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean macMode);

/** 
 Draw a menu item (ex, "&File").

*/
	public native void drawKMenuItem( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean active, QMenuItem item, QBrush fill);
	public native void drawKMenuItem( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean active, QMenuItem item);

/** 
 Draw one block on a progress bar.

*/
	public native void drawKProgressBlock( QPainter p, int x, int y, int w, int h, QColorGroup g, QBrush fill);

/** 
 Retrieve the color used to the background of a progress bar.

 This isn't a drawXXX method due to {@link KProgress} implementation.

*/
	public native void getKProgressBackground( QColorGroup g, QBrush bg);
	public native void drawKickerHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, QBrush fill);
	public native void drawKickerHandle( QPainter p, int x, int y, int w, int h, QColorGroup g);
	public native void drawKickerAppletHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, QBrush fill);
	public native void drawKickerAppletHandle( QPainter p, int x, int y, int w, int h, QColorGroup g);
	public native void drawKickerTaskButton( QPainter p, int x, int y, int w, int h, QColorGroup g, String title, boolean active, QPixmap icon, QBrush fill);
	public native void drawKickerTaskButton( QPainter p, int x, int y, int w, int h, QColorGroup g, String title, boolean active);
	public native void getKickerBackground( int w, int h, int orient, QColorGroup g, QBrush bg);
	public static final int Icon = 0;
	public static final int IconTextRight = 0;
	public static final int Text = 1;
	public static final int IconTextBottom = 2;
	public static final int Top = 0;
	public static final int Left = 0;
	public static final int Right = 1;
	public static final int Bottom = 2;
	public static final int Floating = 3;
	public static final int Flat = 4;
}
