/*
 *  Copyright (C) 2002-2004, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

/**
 * @mainpage Framework for embedding the KJS Javascript Interpreter
 *
 * @section intro Introduction
 *
 * The KJSEmbed library provides a framework that makes it easy for
 * applications to embed KJS, the KDE JavaScript interpreter. The
 * facilities available include a JS console widget, a dialog loader
 * and a binding between JS and the properties and slots of QObjects.
 *
 * @section classes Important Classes
 *
 * The most important classes to consider are:
 *
 * @ref KJSEmbed::KJSEmbedPart :
 *   Main API for KJSEmbed.
 *
 * @ref KJSEmbed::JSConsoleWidget :
 *   A widget that provides an interactive JS console.
 *
 * @ref KJSEmbed::JSObjectProxy :
 *   A Javascript object that can access the properties of a QObject,
 *
 * @ref KJSEmbed::SecurityPolicy :
 *   Defines a security policy for @ref JSObjectProxy.
 *
 * @section basic Basic Usage
 *
 * The simplest way to use KJSEmbed is by simply creating a Javascript
 * console widget. The console allows the user to enter and run arbitrary
 * Javascript expressions.
 * <pre>
 *    KJSEmbed::JSConsoleWidget *win = new KJSEmbed::JSConsoleWidget();
 *    win->show();
 * </pre>
 * The embedding application can run scripts in the console using the
 * execute() method.
 *
 * The best way to use KJSEmbed is keep control of the interpreter
 * yourself using the KJSEmbedPart, this way you can make parts of your
 * application available to scripts. The following example creates its
 * own interpreter then binds it to the console:
 * <pre>
 *    KJSEmbed::KJSEmbedPart *js = new KJSEmbed::KJSEmbedPart();
 *    KJSEmbed::JSConsoleWidget *console = js->view();
 * </pre>
 *
 * @section proxy Publishing QObjects
 *
 * KJSEmbed allows applications to make arbitrary QObjects visible to a
 * Javascript interpreter. The binding itself is provided by the @ref JSProxyObject
 * class, but is more easily used via the addObject(...) methods of @ref KJSEmbedPart.
 *
 * The following code shows how easy it is to make an object available for
 * scripting. It creates a QVBox containing two QLabels then makes them visible
 * to KJSEmbed:
 * <pre>
 *    QVBox *toplevel = new QVBox( 0, "box" );
 *    QLabel *title = new QLabel( "Some Title", toplevel, "title");
 *    QLabel *main = new QLabel( "Some text, more text.", toplevel, "main" );
 *
 *    js->addObject( title );
 *    js->addObject( main, "text" );
 * </pre>
 *
 * Publishing an object makes it possibile for scripts to access both the
 * properties and slots as if it was a normal Javascript object. The code
 * above allows scripts read-write access to the label properties as this
 * script illustrates:
 * <pre>
 *    title.text = "World"
 *    title.text = "Hello " + title.text
 * </pre>
 * The script above would set the text of the label to 'Hello World'.
 *
 * The slots of a QObject bound to the interpreter are made available to
 * scripts as if they normal methods. In the example above, we could conceal
 * the label 'main' entirely by calling its hide() slot:
 * <pre>
 *    main.hide()
 * </pre>
 *
 * @section tree Access To the QObject Tree
 *
 * As well as providing script access to an individual widget, KJSEmbed
 * allows scripts to walk the object tree and access others.  If we
 * modified the previous example to publish the QBox widget 'toplevel' as
 * follows:
 * <pre>
 *    js->addObject( toplevel, "window" );
 * </pre>
 * Then, despite the fact we've only explicitly published a single widget,
 * we've also provided access to both 'main' and 'title'. The ability
 * to navigate the object tree is limited by the SecurityPolicy, the default
 * policy only allows scripts access to children of the published object.
 *
 * To achieve the same result as before, we could use script like this:
 * <pre>
 *    window.child("main").text = "World"
 *    window.child("main").text = "Hello " + window.child("main").text
 * </pre>
 * The result of this script is identical to the previous example.
 *
 */
