/***************************************************************************
                         confdialog.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002-2003 by Aurelien Jarno
    email                : aurelien@aurel32.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFDIALOG_H
#define CONFDIALOG_H

// includes files for Qt
#include <qdialog.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kglobal.h>
#include <kcolorbutton.h>
#include <kurlrequester.h>
#include <kstddirs.h>
#include <kfiledialog.h>

class ConfDialog : public QDialog
{ 
  Q_OBJECT

public:
  ConfDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  
  void setNumEnabled(bool enabled);
  void setCapsEnabled(bool enabled);
  void setScrollEnabled(bool enabled);
  
  // Display tab
  QCheckBox* numLedEnabled;
  QCheckBox* capsLedEnabled;
  QCheckBox* scrollLedEnabled;
  QCheckBox* tooltipsEnabled;
  QCheckBox* popupEnabled;
  QCheckBox* mouseToggle;

  // Leds tab
  QSlider* ledSize;
  QRadioButton* ledVertical;
  QRadioButton* ledHorizontal;
  QRadioButton* ledRectangular;
  QRadioButton* ledCircular;
  QRadioButton* ledFlat;
  QRadioButton* ledRaised;
  QRadioButton* ledSunken;
  KColorButton* ledColor;
    
  // Labels tab
  QCheckBox* labelsEnabled;
  QSlider* labelSize;
  QRadioButton* labelTop;
  QRadioButton* labelBottom;
  QRadioButton* labelLeft;
  QRadioButton* labelRight;
    
  // Startup tab
  QComboBox* numLedStartup;
  QComboBox* capsLedStartup;
  QComboBox* scrollLedStartup;
   
  // Sounds tab
  QCheckBox* soundsEnabled;
  KURLRequester* numLedSoundURL;
  KURLRequester* capsLedSoundURL;
  KURLRequester* scrollLedSoundURL;

protected:
  bool testSoundFiles();  
  
  QTabWidget* tabWidget;

  // Startup tab
  QLabel* numLedStartupLabel;
  QLabel* capsLedStartupLabel;
  QLabel* scrollLedStartupLabel;

  // Sounds tab
  QLabel* numLedSoundLabel;
  QPushButton* numLedSoundPlay;
  QLabel* capsLedSoundLabel;
  QPushButton* capsLedSoundPlay;
  QLabel* scrollLedSoundLabel;
  QPushButton* scrollLedSoundPlay;
  
  // Bottom buttons
  QPushButton* buttonHelp;
  QPushButton* buttonApply;
  QPushButton* buttonOk;
  QPushButton* buttonCancel;

signals:
  void okClicked();
  void applyClicked();
    
protected slots:    
  void slotRequesterClicked(KURLRequester *requester);
  void slotOkClicked();
  void slotCancelClicked();
  void slotApplyClicked();
  void slotHelpClicked();
  void slotNumPlaySound();
  void slotCapsPlaySound();
  void slotScrollPlaySound();
};

#endif // CONFDIALOG_H
