/*********************************************************************
 * $Id: common.c,v 1.4 2000/12/02 01:17:32 orjana Exp $
 * Filename:      common.c
 * Description:   Common definitions and utility functions
 * Status:        Experimental, do not distribute.
 * Author:        rjan Nygaard Austvold <austvold@acm.org>
 * Created at:    Mon Nov 24 21:13:39 2000
 * Modified at:   Sat Dec  2 00:16:38 2000
 * Modified by:   rjan Nygaard Austvold <austvold@acm.org>
 *                
 * Copyright (c) 2000 rjan Nygaard Austvold, All Rights Reserved.
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Revision History:
 *
 *   02-Dec-00 00:16:09   rjan Nygaard Austvold <austvold@acm.org>
 *     Removed cancellation of gui-thread; Main thread is the gui
 *     thread now.
 *
 ********************************************************************/

#include "common.h"

extern gint errno;
extern gboolean gui_is_up;
extern pthread_t led_th;
extern GtkWidget *applet;


/*
 * Function error_handler (log_domain, log_level, message, user_data)
 *
 *    Common error-handler for all Glib calls. Prints out the
 *    message/error on either stderr or in a gnome dialog box.
 *
 */
void error_handler(const gchar *log_domain,
		   GLogLevelFlags log_level,
		   const gchar *message,
		   gpointer user_data)
{
  gchar *msg = g_strconcat(PACKAGE, ": ", message);
  if (gui_is_up) {
    if        (log_level == G_LOG_LEVEL_WARNING) {
      if (applet) gnome_warning_dialog_parented (msg, GTK_WINDOW (applet));
      else        gnome_warning_dialog (msg);

    } else if (log_level == G_LOG_LEVEL_CRITICAL ||
	       log_level == G_LOG_LEVEL_ERROR) {
      if (applet) gnome_error_dialog_parented (msg, GTK_WINDOW (applet));
      else        gnome_error_dialog (msg);

    } else {
      if (applet) gnome_ok_dialog_parented (msg, GTK_WINDOW (applet));
      else        gnome_ok_dialog (msg);
    }
  } else {
    if        (log_level == G_LOG_LEVEL_WARNING)
      g_printerr("%s\n", msg);
  
    else if (log_level == G_LOG_LEVEL_CRITICAL ||
	     log_level == G_LOG_LEVEL_ERROR)
      g_printerr("%s\n", msg);
    else
      g_print("%s\n", msg);
  }
  g_free(msg);

  if (log_level == G_LOG_LEVEL_CRITICAL || log_level == G_LOG_LEVEL_ERROR) {
    /* cancel both threads */
    (void) pthread_cancel (led_th);
    abort();
  }  
}



/*
 * Function readn (fd, ptr, nbytes)
 *
 *    Tries to read nbytes bytes from descriptor fd into storage
 *    pointed to by ptr.
 *
 */
inline gint readn (register gint fd, register gchar *ptr, register gint nbytes)
{
  register gint nleft, nread;
  
  nleft = nbytes;
  while (nleft > 0) {
    if ((nread = read (fd, ptr, nleft)) <= 0)
      return -1;
    
    nleft -= nread;
    ptr   += nread;
  }

  return nbytes;
}



/*
 * Function writen (fd, ptr, nbytes)
 *
 *    Tries to write nbytes bytes to descriptor fd from storage
 *    pointed to by ptr.
 *
 */
inline int writen (register gint fd, register gchar *ptr, register gint nbytes)
{
  register gint nleft, nwritten;

  nleft = nbytes;
  while (nleft > 0) {
    if ((nwritten = write (fd, ptr, nleft)) == -1)
      return -1;

    nleft -= nwritten;
    ptr   += nwritten;
  }
  
  return nbytes;
}
