/***************************************************************************
                          kfxenddate.h  -  description
                             -------------------
    begin                : Fri Sep 7 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFXENDDATE_H
#define KFXENDDATE_H

#include <qobject.h>
#include <qdom.h>
class KFMEndDate;

/**XML class for enddates
  *@author Jeffrey Yu
  */

class KFXEndDate : public QObject  {
public:
	/** Create an object to read and write xml enddates
			@param doc Parent dom document.  Must be non-null to
					generate a dom element.
			@param endDate Enddate from which to read and write data
		*/
	KFXEndDate(QDomDocument* doc, KFMEndDate* endDate);
	~KFXEndDate();
	
	/** Retrieve the xml tag for the enddate
			@return XML tagname for the enddate
		*/
	static QString xmlTag();
	
	/** Retrieve a dom description of the enddate
			@return DOM element for the enddate
		*/
	QDomElement domElement() const;
	/** Specify a dom description for the enddate
			@param element DOM element for the enddate
		*/
	void domElement(QDomElement element);
	
//////////////////////////////////////////////////////
private:
	/** dom document */
	QDomDocument* doc_;
	/** enddate model */
	KFMEndDate* endDate_;
	
};

#endif
