/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>

#ifndef _COMMANDS_H
#define _COMMANDS_H

struct navigate_control {
    gint       step;
    gint       rate;
    gint       subframe;
    gboolean   active;
    gboolean   escaped;
	gboolean   capture_active;
};

#ifdef __cplusplus
extern "C" {
#endif

void kinoInitialise( GtkWidget * );
void kinoDeactivate( void );

void bulkLoad(int argc, char* argv[]);
void newFile( void );
void openFile( void );
void savePlayListAs( void );
void savePlayList( void );
void saveMovie( void );
void saveFrame( void );
void insertFile( void );
void appendFile( void );

void refresh( void );

gboolean processKeyboard( GdkEventKey *event );
void processMenuCommand( char *command );
void processCommandLine( char *command );

void pageStart( int );

int moveToFrame( int );
void videoStart( void );
void videoPreviousScene( void );
void videoStartOfScene( void );
void videoRewind( void );
void videoBack( void );
void videoPlay( void );
void videoPause( void );
void videoStop( void );
void videoForward( void );
void videoFastForward( void );
void videoNextScene( void );
void videoEndOfScene( void );
void videoEndOfMovie( void );
void videoShuttle( int );
void windowChanged( void );
void windowMoved( void );
void visibilityChanged( gboolean );
void selectScene( int );
void showIcons( GtkWidget * );
void selectIcon( GtkWidget *, int );
void notebookChangePage( int );
void stop_navigator( void );
void startCapture( void );
void stopCapture( void );
void view50percent( void );
void view100percent( void );
void toggleShowInfo( void );
void startExport( void );
void stopExport( void );
void setExportMode( int );

// Old and deprecated functions

int Play(GtkWidget *drawingarea, int first, int last, gboolean no_audio);
void InitBar(GtkWidget *drawingarea, int currentFrame);
void DrawBar(GtkWidget *drawingarea, int currentFrame);
void ResetBar(GtkWidget *drawingarea);
void RefreshBar(GtkWidget *drawingarea);
gint navigator(struct navigate_control *ctl);
int getOneSecond(void);

#ifdef __cplusplus
}
#endif

#endif
