/*
 * page_timeline.cc Notebook Timeline Page Object
 * Copyright (C) 2001 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <iostream>

#include "page_timeline.h"
#include "page_editor.h"

/*
 * Callbacks
 */

extern "C" {

	extern KinoCommon *common;

	int getOneSecond(void)
	{
		static Frame frame;
		common->getPlayList()->GetFrame(common->g_currentFrame, frame);
		return (frame.IsPALfromHeader() ? 25 : 30);
	}
	
	static unsigned char	  pixels[720*576*4];

	void showIcons( GtkWidget *list ) 
	{
		static Frame frame;
		GdkImlibImage *image;
		GdkImlibImage *scaled;
		GtkWidget *start_spin = lookup_widget( list, "start_spin" );
		GtkWidget *end_spin = lookup_widget( list, "end_spin" );
		GtkWidget *time_spin = lookup_widget( list, "time_spin" );
		int start;
		int end;
		float time;
		char label[ 256 ] = "";
		//frame.decoder->quality = DV_QUALITY_COLOR | DV_QUALITY_DC;
		sscanf( gtk_entry_get_text( GTK_ENTRY( start_spin ) ), "%d", &start );
		sscanf( gtk_entry_get_text( GTK_ENTRY( end_spin ) ), "%d", &end );
		sscanf( gtk_entry_get_text( GTK_ENTRY( time_spin ) ), "%f", &time );
		gnome_icon_list_freeze( GNOME_ICON_LIST( list ) );
		gnome_icon_list_clear( GNOME_ICON_LIST( list ) );
		for ( int index = start; index < common->getPlayList()->GetNumFrames() && index < end; index += (int)( (float)getOneSecond() * (float)time ) ) {
			common->getPlayList()->GetFrame(index, frame);
			frame.ExtractRGB(pixels);
			image = gdk_imlib_create_image_from_data( pixels, NULL, 720, frame.IsPAL() ? 576 :480 );
			scaled = gdk_imlib_clone_scaled_image( image, 90, 72 );
			sprintf( label, "%d", index );
			int pos = gnome_icon_list_append_imlib( GNOME_ICON_LIST(list), scaled, label );
			gnome_icon_list_set_icon_data( GNOME_ICON_LIST(list), pos, strdup( label ) );
			gdk_imlib_destroy_image( image );
		}
		gnome_icon_list_thaw( GNOME_ICON_LIST( list ) );
	}

	void selectIcon( GtkWidget *widget, int icon )
	{
		gpointer ptr = gnome_icon_list_get_icon_data( GNOME_ICON_LIST( widget ), icon );
		int val = 0;
		// Get the frame and move to it
		sscanf( (char *)ptr, "%d", &val );
		common->moveToFrame( val );
		// Go to editor window
		common->changePageRequest( 0 );
	}

	void
	on_iconlist1_select_icon               (GnomeIconList   *gnomeiconlist,
                                        	gint             arg1,
                                        	GdkEvent        *event,
                                        	gpointer         user_data)
	{
		selectIcon( GTK_WIDGET( gnomeiconlist ), arg1 );
	}

	void
	on_timeline_ok_button_pressed          (GtkButton       *button,
                                        	gpointer         user_data)
	{
		showIcons( lookup_widget( GTK_WIDGET( button ), "iconlist1" ) );
	}
}

void PageTimeline::start() {
	cout << ">> Starting timeline" << endl;
}

void PageTimeline::selectScene( int i ) {
	cout << "Time line scene " << i << endl;
	GtkWidget *start_spin = lookup_widget( common->getWidget(), "start_spin" );
	GtkWidget *end_spin = lookup_widget( common->getWidget(), "end_spin" );
	GtkAdjustment *adjust = gtk_spin_button_get_adjustment( GTK_SPIN_BUTTON( start_spin ) );
	vector <int> scene = common->getPageEditor()->GetScene();

	int value = i == 0 ? 0 : scene[ i - 1 ];
	adjust->lower = 0;
	adjust->upper = scene[ scene.size() - 1 ];
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( start_spin ), value );
	gtk_signal_emit_by_name( GTK_OBJECT( adjust ), "changed" );

	adjust = gtk_spin_button_get_adjustment( GTK_SPIN_BUTTON( end_spin ) );

	adjust->lower = 0;
	adjust->upper = scene[ scene.size() - 1 ];
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( end_spin ), scene[ i ] );
	gtk_signal_emit_by_name( GTK_OBJECT( adjust ), "changed" );

	showIcons( lookup_widget( common->getWidget(), "iconlist1" ) );
}

gulong PageTimeline::activate() {
	return SCENE_LIST;
}

