// $Id:

/*
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <iostream>
using std::cout;
using std::endl;

#include "preferences.h"
#include "kino_common.h"
#include <string.h>
#include <libgnome/gnome-config.h>

/** The global prefs object.
    
    It is accessible to other classes via the getInstance method.
*/

Preferences *Preferences::instance = NULL;

/** Singleton getInstance method. Standard pattern followed, non threadsafe
	but not required (at the moment) since it gets called before any threading
	is activated. Keep an eye on it though.

	\returns the single instance of Preferences.
*/

Preferences &Preferences::getInstance() {
	if ( instance == NULL )
		instance = new Preferences;
	return *instance;
}

/** The constructor loads the user preferences.

    Since this uses gnome-config, preferences are typically
    loaded from ~/.gnome/kino.
*/
Preferences::Preferences() {
    gchar key[256];
    gchar *tempString;

	cout << "Preferences constructed" << endl;
    gnome_config_push_prefix("/kino/general/");

    tempString = gnome_config_get_string("file=capture");
    if (tempString) {
        strncpy( file, tempString, 511);
        g_free(tempString);
    }
    g_snprintf( key, 255, "fileFormat=%d", AVI_DV1_FORMAT);
    fileFormat = gnome_config_get_int(key);
    autoSplit = gnome_config_get_bool("autoSplit=true");
    timeStamp = gnome_config_get_bool("timeStamp=false");
    frames = gnome_config_get_int("frames=7000");
    every = gnome_config_get_int("every=1");
    interface = gnome_config_get_int("interface=0");
    channel = gnome_config_get_int("channel=63");
    phyID = gnome_config_get_int("phyID=-1");
    g_snprintf( key, 255, "displayMode=%d", DISPLAY_XV);
    displayMode = gnome_config_get_int(key);
    displayQuality = gnome_config_get_float("displayQuality=2");
    enableAudio = gnome_config_get_bool("enableAudio=true");
    cip_n = gnome_config_get_int("cip_increment=0");
    cip_d = gnome_config_get_int("cip_threshold=0");
    syt_offset = gnome_config_get_int("syt_offset=19000");
    preview_capture = gnome_config_get_bool("preview_capture=false");
    dropFrame = gnome_config_get_bool("dropFrame=true");
    audioDevice = gnome_config_get_string("audioDevice=/dev/dsp");
    enableJogShuttle = gnome_config_get_bool("enableJogShuttle=false");
    jogShuttleDevice = gnome_config_get_string("jogShuttleDevice=/dev/input/event0");
	enableV4L = gnome_config_get_bool( "enableV4L=false" );
	disableKeyRepeat = gnome_config_get_bool( "disableKeyRepeat=false");
	audioRendering = gnome_config_get_int( "audioRendering=0" );
	previewRendering = gnome_config_get_int( "previewRendering=1" );
	enableTimecode = gnome_config_get_bool( "enableTimecode=false" );

    gnome_config_pop_prefix();
}

/** Save the user preferences.
*/

/// Save the user preferences.
void
Preferences::Save() {
    gnome_config_push_prefix("/kino/general/");

    gnome_config_set_string( "file", file);
    gnome_config_set_int("fileFormat", fileFormat);
    gnome_config_set_bool("autoSplit", autoSplit);
    gnome_config_set_bool("timeStamp", timeStamp);
    gnome_config_set_int("frames", frames);
    gnome_config_set_int("every", every);
    gnome_config_set_int("interface", interface);
    gnome_config_set_int("channel", channel);
    gnome_config_set_int("phyID", phyID);
    gnome_config_set_int("displayMode", displayMode);
    gnome_config_set_float("displayQuality", displayQuality);
    gnome_config_set_bool("enableAudio", enableAudio);
    gnome_config_set_int("cip_increment", cip_n);
    gnome_config_set_int("cip_threshold", cip_d);
    gnome_config_set_int("syt_offset", syt_offset);
    gnome_config_set_bool("preview_capture", preview_capture);
    gnome_config_set_bool("dropFrame", dropFrame);
    gnome_config_set_string("audioDevice", audioDevice);
    gnome_config_set_bool("enableJogShuttle", enableJogShuttle);
    gnome_config_set_string("jogShuttleDevice", jogShuttleDevice);
    gnome_config_set_bool("enableV4L", enableV4L);
    gnome_config_set_bool("disableKeyRepeat", disableKeyRepeat);
    gnome_config_set_int("audioRendering", audioRendering);
    gnome_config_set_int("previewRendering", previewRendering);
    gnome_config_set_bool("enableTimecode", enableTimecode);
    gnome_config_pop_prefix();

    gnome_config_sync();
}


/// Provide access to the audioDevice propery from C modules.
gchar *Preferences_getAudioDevice(void)
{
    return Preferences::getInstance().audioDevice;
}

