#ifndef KP_CALENDAR_ENTRY_H_
#define KP_CALENDAR_ENTRY_H_

#include "kpcalendartime.h"

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#define KP_TYPE_CALENDAR_ENTRY (kp_calendar_entry_get_type())
#define KP_CALENDAR_ENTRY(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_CALENDAR_ENTRY, KPCalendarEntry))
#define KP_CALENDAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_CALENDAR_ENTRY, KPCalendarEntryClass))
#define KP_IS_CALENDAR_ENTRY(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_CALENDAR_ENTRY))
#define KP_IS_CALENDAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_CALENDAR_ENTRY))
#define KP_CALENDAR_ENTRY_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_CALENDAR_ENTRY, KPCalendarEntryClass))

typedef struct KPCalendarEntry_ KPCalendarEntry;
typedef struct KPCalendarEntryClass_ KPCalendarEntryClass;

struct KPCalendarEntry_
{
  GObject           parent_instance;

 /* Private */
  KPCalendarTime   *datetime;
};

struct KPCalendarEntryClass_
{
  GObjectClass parent_class;

  gchar *           (*get_human_name) (KPCalendarEntry *entry);
  gchar *           (*to_string) (KPCalendarEntry *entry);
  xmlNodePtr        (*to_xml) (KPCalendarEntry *entry);
  gboolean          (*parse) (KPCalendarEntry *entry, xmlNodePtr node);
};

GType               kp_calendar_entry_get_type       (void);
KPCalendarEntry    *kp_calendar_entry_new            (void);
gchar              *kp_calendar_entry_to_string      (KPCalendarEntry *entry);
xmlNodePtr          kp_calendar_entry_to_xml         (KPCalendarEntry *entry);

KPCalendarTime     *kp_calendar_entry_get_date       (KPCalendarEntry *entry);

gboolean            kp_calendar_entry_parse          (KPCalendarEntry *entry,
                                                      xmlNodePtr node);
gint                kp_calendar_entry_cmp            (const KPCalendarEntry *entry,
                                                      const KPCalendarEntry *entry2);
gchar              *kp_calendar_entry_get_human_name (KPCalendarEntry *entry);


#endif
