/*
 * classpath_missing.c - functions missing from native code segments of
 *   the Classpath Java libraries
 *
 * Copyright (C) 2001, J. Russell Smyth
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <assert.h>
#include <jni.h>


#include "../lib/classpath/java.math/java_math_BigInteger.h"
#include "classpath_missing.h"
#include "../vm/newobject.h"


#include <stdio.h>
#include <string.h>


#define MAXNUMLEN 64
#define DSIGNBIT 0x8000000000000000LL

JNIEXPORT jobject JNICALL Java_java_math_BigInteger_subtact
(JNIEnv * env, jobject obj, jobject val){
  assert(2==3);
  // this is obviously wrong! (jrs)
       return obj;
}
JNIEXPORT void JNICALL Java_java_math_BigInteger_print
(JNIEnv * env, jobject obj){
  assert(2==3);
}


/*
 * Convert a "normal" double to a string with the supplied precision.
 *
 * This assumes printf(3) conforms to ISO 9899: 1990 (``ISO C'').
 *
 * XXX We still print some values incorrectly. For example the double
 * XXX 0x400B333333333333 should be displayed as "3.4" instead of what
 * XXX we display, "3.3999999999999999".
 */
jstring Java_java_lang_Double_toStringWithPrecision(JNIEnv* env, jclass Doubleclazz, jint precision, jdouble val)
{
  const jlong bits = Java_java_lang_Double_doubleToLongBits(val);
  char *s, buf[MAXNUMLEN];
  int k;

  /* Deal with negative numbers manually so negative zero is "-0.0" */
  s = buf;
  /*
  if (bits & DSIGNBIT) {
    val = -val;
    *s++ = '-';
  }
  */
  /* Print in normal or 'scientific' form according to value */
  if (val == 0.0 || (val >= 1.0e-3 && val < 1.0e7)) {
    static const double powTen[] = {
      1.0e0, 1.0e1, 1.0e2, 1.0e3, 1.0e4, 1.0e5, 1.0e6
    };

    /* Account for precision digits ahead of the decimal point */
    for (k = 6; k >= 0 && val < powTen[k]; k--);
    precision -= k + 1;

    /* Print in decimal notation */
    sprintf(s, "%.*f", (int) precision, (double) val);

    /* Remove trailing zeroes after the decimal point */
    for (k = strlen(buf) - 1;
	 buf[k] == '0' && buf[k - 1] != '.';
	 k--) {
      buf[k] = '\0';
    }
  } else {
    char *t, *eptr, *eval;

    /* Print in exponential notation */
    sprintf(s, "%.*E", (int) precision - 1, (double) val);
    
    /* Find the exponent */
    eptr = strchr(buf, 'E');
    assert(eptr != NULL);
    
    /* Remove a '+' sign, but leave a '-' sign */
    switch (eptr[1]) {
    case '-':
      eval = &eptr[2];
      break;
    case '+':                       /* remove '+' */
      memmove(eptr + 1, eptr + 2, strlen(eptr + 1));
      /* fall through */
    default:                        /* shouldn't ever happen */
      eval = &eptr[1];
      break;
    }

    /* Remove leading zeroes in the exponent, if any */
    for (t = eval; t[0] == '0' && t[1] != '\0'; t++);
    memmove(eval, t, strlen(t) + 1);
    
    /* Remove trailing zeroes after the decimal point */
    for (t = eptr - 1; *t == '0' && t[-1] != '.'; t--);
    memmove(t + 1, eptr, strlen(eptr) + 1);
  }

  return INTERP_NewStringFromAsciz(env,buf); //(stringC2Java(buf));
}

