package teaseme.base.shells.jterm;

import teaseme.console.Console;
import teaseme.console.ConsoleAPI;

import java.awt.Point;

import java.util.Vector;

import java.io.IOException;

public class JTerm implements Runnable {

  private Console ourConsole;
  private boolean isReady;

  public JTerm(Console c)
  {
    init(c);
  }
  
  public JTerm()
  {
    ConsoleAPI api = teaseme.console.ConsoleFactory.getConsoleAPIImpl();
    init( api.openConsole());
  }

  private void init(Console c)
  {
    ourConsole = c;
    rows = ourConsole.getConsoleHeightAndWidth().height;
    cols = ourConsole.getConsoleHeightAndWidth().width;
    new Thread(this).start();

    //wait for it to get ready
    while(isReady == false) { }
			     
    writeToTerminal("Rows is " + rows + " and cols " + cols);
    
  }

  private Vector inputBuffer = new Vector();
  private Vector outputBuffer = new Vector();
  private boolean wantOutput;
  private boolean wantEnd;

  public void run()
  {
    while(true) /* we loop until we are told to quit */
      {
	//	if(wantOutput)
	//	  {
	    flushOutputBuffer();
	    //	  }

	if(wantEnd == true)
	  break;

	isReady = true;
	if(ourConsole.hasInput())
	  {
	    int c =  ourConsole.readChar();
	    synchronized(inputBuffer)
	      {
		inputBuffer.addElement(new Character( (char) c));
		inputBuffer.notify();
	      }
	  }
      }
    System.err.println("Input thread terminated");
  }

  public int readFromTerminal()
  {
    while(true)
      {
	synchronized(inputBuffer)
	  {
	    if(inputBuffer.size() > 0)
	      {
		Character top = (Character) inputBuffer.elementAt(0);
		inputBuffer.removeElement(top);
		return (int) top.charValue();
	      }
	    else
	      {
		try {
		inputBuffer.wait();
		} catch(InterruptedException e)
		  {
		  }
	      }
	  }
      }
  }
  
  public synchronized void flushOutputBuffer()
  {
    int els = outputBuffer.size();
    for(int i = 0; i < els;i++)
      {
	printChar( ((Character) outputBuffer.elementAt(i)).charValue());
      }
    outputBuffer.removeAllElements();
    wantOutput = false;
  }

  public synchronized void writeToTerminal(char c)
  {
    writeToTerminal(c + "");
  }
  public synchronized void writeToTerminal(String s)
  {
    for(int i = 0; i < s.length();i++)
      {
	outputBuffer.addElement( new Character( s.charAt(i)));
      }
    wantOutput = true;
  }

  private int xpos = 0;
  private int ypos = 0;
  
  private int cols;
  private int rows;

  public void printChar(char c)
  {
    if(xpos == (cols - 1))
      {
	xpos = 0;
	ypos++;
      }
    else
      {
	xpos++;
      }
    ourConsole.setCurrentCursorPosition(new Point(xpos, ypos));
    ourConsole.writeChar(c);
  }

  public void destroy()
  {
    ourConsole.close();
    wantEnd = true;
  }
}
