/*
 * Copyright (C) 2000, 2001 Robert Fitzsimons
 */

#include "kinterface.h"
#include "wrappers.h"

#ifdef MYCODE
kfunction void kspinlock_lock(volatile kuint* lock) {

  while(katomic_compare_and_set_if_equal(lock, 0, sys_current_thread()) != 0)
    {
      #ifdef KISSME_LINUX_KERNEL
      schedule() ;
      #endif
    }
  //  eprintf("After lock %p %x\n", lock, *lock);
}

kfunction void kspinlock_unlock(volatile kuint* lock) {

  if(*lock != sys_current_thread())
    {
      eprintf("Doing unlock for %x when current thread is %x\n", *lock, sys_current_thread());
    }
    assert(*lock == sys_current_thread());
  while(katomic_compare_and_set_if_equal(lock,  sys_current_thread(), 0) != 0)
    {
      #ifdef KISSME_LINUX_KERNEL
      schedule() ;
      #endif
    }
  //  eprintf("After unlock %p %x\n", lock, *lock);
}

#endif

#ifdef ROBERTLOCKS
kfunction void kspinlock_lock(volatile kuint* lock) {
	while(katomic_bit_test_and_set(lock, 0)) {}
}

kfunction void kspinlock_unlock(volatile kuint* lock) {
	katomic_bit_reset(lock, 0);
}
#endif

#ifndef MIPSEL

#define LOCK "lock ;"

kfunction void kspinlock_lock(volatile kuint* lock) {

  asm volatile(
	       "0: ;"
	       LOCK "btsl $31, (%0) ;"
	       "jc 0b ;"
	       : "=d" (lock)
	       : "0" (lock)
	       );
  //  eprintf("%x Acquired lock %p\n", sys_current_thread(), lock);
}

kfunction void kspinlock_unlock(volatile kuint* lock) {
  asm volatile(
	       LOCK "btrl $31, (%0) ;"
	       : "=d" (lock)
	       : "0" (lock)
	       );
}

#endif

kfunction void kspinlock_read_lock(volatile kuint* lock) {
}

kfunction void kspinlock_read_unlock(volatile kuint* lock) {
}

kfunction void kspinlock_write_lock(volatile kuint* lock) {
}

kfunction void kspinlock_write_unlock(volatile kuint* lock) {
}

#ifdef NOOOOKISSME_RJK_KERNEL

kfunction void kspinlock_lock_irqsave(volatile kuint* lock, kuint* flags) {
	kprocessor_save_flags(flags);
	kirq_disable_all();
	kspinlock_lock(lock);
}

kfunction void kspinlock_unlock_irqrestore(volatile kuint* lock, kuint* flags) {
	kprocessor_restore_flags(flags);
	kspinlock_unlock(lock);
}


#endif
