/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "aboutklamav.h"
#include "pageviewer.h"
#include "tabwidget.h"


#include <klocale.h>

#include <kstandarddirs.h>
#include <kstandarddirs.h>

#include <qlayout.h>


using namespace KlamAV;

Aboutklamav::Aboutklamav(QWidget *parent, const char *name)
    : QWidget(parent, name)
{

// 	QString location = locate("data", "klamav/about/klam.png");
// 	QPixmap image0;
// 	QImage img;
// 
// 	//img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
// 	img.load(location,"PNG");
// 	image0 = img;


	QVBoxLayout *vbox = new QVBoxLayout(this, KDialog::marginHint(),
			KDialog::spacingHint(), "vbox");

	QWidget* privateLayoutWidget = new QWidget( this, "dblayout" );
	vbox->addWidget(privateLayoutWidget);

	QGridLayout* dblayout = new QGridLayout( privateLayoutWidget, 1, 1, 2, 2, "dblayout"); 
	dblayout->setColStretch(1, 1);

	tabBrowser = new TabWidget(privateLayoutWidget);
	dblayout->addMultiCellWidget( tabBrowser, 0, 1, 1, 1 );

	homepage = new PageViewer(this, "page");

	connect( homepage, SIGNAL(setWindowCaption (const QString &)),
		this, SLOT(slotTabCaption (const QString &)) );
	connect( homepage, SIGNAL(urlClicked(const KURL &,bool)),
		this, SLOT(slotOpenTabPlain(const KURL &,bool)) );
	
	Frame *frame=new Frame(this, homepage, homepage->widget(), i18n( "About KlamAV") );
	tabBrowser->addFrame(frame);
	
	tabBrowser->showPage(homepage->widget());
	setFocus();
	
	QString location = locate("data", "klamav/about/aboutklamav.html");
	
	homepage->openURL(location);


	//KMessageBox::information (this,nooffilters);

/*	QGroupBox *groupBox1 = new QGroupBox( "About KlamAV",this );
	vbox->addWidget(groupBox1);

	groupBox1->setGeometry( QRect( 20, 40, 551, 391 ) );
	
	QLabel *pixmapLabel1 = new QLabel( groupBox1, "pixmapLabel1" );
	pixmapLabel1->setGeometry( QRect( 60, 110, 140, 140 ) );
	pixmapLabel1->setPixmap( image0 );
	pixmapLabel1->setScaledContents( TRUE );
	
	QLabel *textLabel1_2 = new QLabel( "KlamAV \n(C) Robert Hogan <hoganrobert@klamav.sf.net>",groupBox1 );
	textLabel1_2->setGeometry( QRect( 230, 80, 421, 61 ) );
	
	QLabel *textLabel1_3 = new QLabel( "http://klamav.sourceforge.net",groupBox1 );
	textLabel1_3->setGeometry( QRect( 230, 130, 221, 21 ) );

	QLabel *textLabel1 = new QLabel( "Translators:\nRussian, Vitaly Lipatov \n German, Marc Hansen",groupBox1 );
	textLabel1->setGeometry( QRect( 230, 150, 401, 61 ) );
	
	
	QLabel *textLabel1 = new QLabel( "ClamAV \n(C) Tomasz Kojm <tkojm@clamav.net>",groupBox1 );
	textLabel1->setGeometry( QRect( 230, 20, 401, 61 ) );
	
	QLabel *textLabel1_4 = new QLabel( "http://www.clamav.net",groupBox1 );
	textLabel1_4->setGeometry( QRect( 230, 250, 221, 21 ) );

	pixmapLabel1->setPixmap( image0 );
	pixmapLabel1->setScaledContents( TRUE );
	*/
	//resize( QSize(600, 480).expandedTo(minimumSizeHint()) );




		


}

void Aboutklamav::slotOpenTabPlain(const KURL& url, bool background)
{

    kdDebug() << "opening tabplain" << endl;
    PageViewer* page = new PageViewer(this, "page");
    //connect( m_part, SIGNAL(signalSettingsChanged()), page, SLOT(slotPaletteOrFontChanged()));
    
/*    connect( page, SIGNAL(setTabIcon(const QPixmap&)),
            this, SLOT(setTabIcon(const QPixmap&)));*/
    connect( page, SIGNAL(setWindowCaption (const QString &)),
            this, SLOT(slotTabCaption (const QString &)) );
    connect( page, SIGNAL(urlClicked(const KURL &,bool)),
            this, SLOT(slotOpenTabPlain(const KURL &,bool)) );

    Frame *frame=new Frame(this, page, page->widget(), i18n("Untitled"));
    //connectFrame(frame);
    tabBrowser->addFrame(frame);

    if(!background)
        tabBrowser->showPage(page->widget());
    else
        setFocus();
    
    //if (m_tabs->count() > 1 && m_tabs->currentPageIndex() != 0)
//        m_tabsClose->setEnabled(true);

    //kdDebug() << url << endl;
    page->openURL(url);
}

void Aboutklamav::slotTabCaption(const QString &caption)
{
    if (!caption.isEmpty())
    {
        PageViewer *pv=(PageViewer *)sender();
        tabBrowser->setTitle(caption, pv->widget());
        pv->slotSetCaption(caption);
    }
}


Aboutklamav::~Aboutklamav()
{
}

#include "aboutklamav.moc"





