/* definitions for a looper */

#ifndef __LOOPER_H__
#define __LOOPER_H__

#include <gtk/gtk.h>
#include <glib.h>
#include "../../common/looperdata.h"
#include "gtkloopview.h"
#include "../../common/speciallist.h"
#include "../../common/shuttle.h"

typedef struct _looper_list {
        GList   *listptr;
        GMutex  *listmutex;
} looper_list_t;

typedef struct _looper_gui {
	/* for usb hid interaction */
	shuttle_data_t  *shuttle;

	/* for mix <-> gui communication */
	looper_data_t	*data;
	int		id;
	int		gid;
	GtkWidget	*parent;
	GtkWidget	*parentcontainer;
	int 		vposition;
	long		samplerate;
/*	GList		*bufferlist;*/
	speciallist_t   *bufferlist;
	speciallist_t	*looperdatalist;
	speciallist_t	*clickmodes;

	/* for avoiding gui-loopbacks */
	gboolean 	loopstartblock;
	gboolean	loopendblock;
	gboolean	looplengthblock;
	gboolean        recstartblock;
	gboolean        recendblock;
	gboolean        reclengthblock;
	gboolean	speedblock;

	/* update meters every second round */
	gboolean	vublock;
	

	/* meta-gui widgets */
	PangoFontDescription *font;
	GtkTooltips 	*tooltips;
	GtkWidget	*mainbox;	/* hbox */
	GtkWidget	*topbox;
	GtkWidget	*controlbox;	/* vbox */
	GtkWidget	*middletable;	/* table */
	GtkWidget	*middlebox;	/* hbox */
	GtkWidget	*smalltable;	/* vbox */
	GtkWidget	*smallbox;	/* vbox */
	GtkWidget	*grainbox;	/* hbox */
	GtkWidget	*panbox;	/* hbox */
	GtkWidget       *controlframe;
	GtkWidget	*customcurvedialog;
	
	/* specific widgets */
	GtkWidget	*loopview;		/* loopview */
	GtkWidget	*buffermenu;		/* menu */
	GtkWidget	*menu_bar;		/* menubar */
	GtkWidget	*optionsmenu;		/* menu */
	GtkWidget	*limiteritem;		/* menu item */
	GtkWidget	*snap2griditem;		/* menu item */
	GtkWidget	*showgriditem;		/* menu item */
	GtkWidget	*loopmode;		/* menu item */
	GtkWidget	*backforthmode;		/* menu item */
	GtkWidget	*oncemode;		/* menu item */
	GtkWidget	*sinewavemode;		/* menu item */
	GtkWidget	*externalposmode;	/* menu item */
	GtkWidget	*customspeedmode;	/* menu item */
	GtkWidget	*customposmode;		/* menu item */
	GtkWidget	*recloopmode;		/* menu item */
	GtkWidget	*reconcemode;		/* menu item */
	GtkWidget	*thresholdtoggle;	/* menu item */
	GtkWidget	*playmodemenu;		/* menu */
	GtkWidget	*playbutton; 		/* toggle_button */
	GtkWidget	*recbutton; 		/* toggle_button */
	GtkWidget	*normbutton;		/* button */
	GtkWidget	*shuttlebutton;		/* toggle_button */
	GtkWidget	*minimizebutton;	/* toggle_button */
	GtkWidget	*upbutton;		/* button */
	GtkWidget	*downbutton;		/* button */
	GtkWidget	*upimage;		/* image.*/
	GtkWidget	*downimage;		/* image */
	GtkWidget	*playimage;		/* image */
	GtkWidget	*recimage;		/* image */

	GtkWidget	*outLmeter; 		/* vumeter */
	GtkWidget	*outRmeter; 		/* vumeter */
	GtkWidget	*inLmeter; 		/* vumeter */
	GtkWidget	*inRmeter; 		/* vumeter */

	GtkWidget	*volslider;		/* vscale */
	GtkWidget	*recmixslider;		/* vscale */
	GtkWidget	*panslider;		/* hscale */
	GtkWidget	*ngrainslider;		/* hscale */

	GtkWidget	*loopstartspin;		/* spinbutton */
	GtkWidget	*loopendspin;		/* spinbutton */
	GtkWidget	*looplengthspin;	/* spinbutton */
	GtkWidget	*recstartspin;		/* spinbutton */
	GtkWidget	*recendspin;		/* spinbutton */
	GtkWidget	*reclengthspin;		/* spinbutton */
	GtkWidget	*speedspin;		/* spinbutton */
	GtkWidget	*diversityspin;		/* spinbutton */
	GtkWidget	*densityspin;		/* spinbutton */
	GtkWidget	*panswingspin;		/* spinbutton */

	GtkWidget	*recloopcheck;		/* checkbutton */
	GtkWidget	*playloopcheck;		/* checkbutton */
	
} looper_gui_t;

looper_gui_t* looper_new(GtkWidget* parent, GtkWidget* parentcontainer, speciallist_t *looperdatalist, 
				speciallist_t *clickmodes, int id, int minimized);
int looper_update_bufferlist(looper_gui_t* loop, speciallist_t *bufferlist);
int looper_update_loopername(gchar* name);
void looper_update_cursorposition (looper_gui_t *looper);
void looper_update_widgets(looper_gui_t *looper);
void looper_set_samplerate (looper_gui_t *looper,long samplerate);
void looper_set_buffer_by_id (looper_gui_t *looper, int id);
void looper_suspend_gui (looper_gui_t *looper, int suspend);

looper_data_t* looper_get_looperdata (looper_gui_t *looper);

looper_list_t* looper_list_new();
void looper_close (looper_gui_t *looper);
looper_list_t* looper_list_append_looper(looper_list_t* list, looper_gui_t *loop);
looper_list_t* looper_list_remove_looper(looper_list_t* list, looper_gui_t *loop);

int looper_get_position(looper_gui_t *loop);
void looper_set_position(looper_gui_t *loop, int pos);


/* LATER*/
looper_list_t* looper_list_delete(looper_list_t* list);

#endif
