/*******************************************************************************
***	                       class IdleTimer	                     ***************
***                      Original from KArm                      ***************
***                    changed from Olaf Lueg                    ***************
*******************************************************************************/

#include "idle.h"
#include <qmessagebox.h>
#include <klocale.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <kdebug.h>

IdleTimer::IdleTimer(int maxIdle) 
{
  _maxIdle = maxIdle;
  isIdle = false;

#ifdef HAVE_LIBXSS
  int event_base, error_base;
  if(XScreenSaverQueryExtension(qt_xdisplay(), &event_base, &error_base)) {
    _idleDetectionPossible = true;
  }
  else {
    _idleDetectionPossible = false;
  }

  _timer = new QTimer(this);
  connect(_timer, SIGNAL(timeout()), this, SLOT(check()));
#else
  _idleDetectionPossible = false;
#endif // HAVE_LIBXSS

}

bool IdleTimer::isIdleDetectionPossible()
{
  return _idleDetectionPossible;
}

void IdleTimer::check() 
{
#ifdef HAVE_LIBXSS
  if (_idleDetectionPossible) {
    _mit_info = XScreenSaverAllocInfo ();
    XScreenSaverQueryInfo(qt_xdisplay(), qt_xrootwin(), _mit_info);
    int idleMinutes = (_mit_info->idle/1000)/secsPerMinutes;;
   	if (idleMinutes >= _maxIdle) {
     	informOverrun(idleMinutes);  // system is idle
     	idleSince = _mit_info->idle;
    }
    if(isIdle){
    	if(idleSince != _mit_info->idle){
    		emit idleDetected(false); // the system has changed from inactive to active
    		isIdle = false;
    	}
    }

  }
#endif // HAVE_LIBXSS
}

void IdleTimer::setMaxIdle(int maxIdle)
{
  _maxIdle = maxIdle;
}

#ifdef HAVE_LIBXSS
void IdleTimer::informOverrun(int idleMinutes) 
{
  if (!_overAllIdleDetect) {
    return; // In the preferences the user has indicated that he do not
            // want idle detection.
  }

//  _timer->stop();
  if(!isIdle){
  	emit idleDetected(true);
  	isIdle = true;
  }
//  _timer->start(testInterval);
}
#endif // HAVE_LIBXSS

void IdleTimer::startIdleDetection() 
{
#ifdef HAVE_LIBXSS
  if (!_timer->isActive())
    _timer->start(testInterval);
#endif //HAVE_LIBXSS
}

void IdleTimer::stopIdleDetection()
{
#ifdef HAVE_LIBXSS
  if (_timer->isActive())
    _timer->stop();
#endif // HAVE_LIBXSS
}
void IdleTimer::toggleOverAllIdleDetection(bool on) 
{
  _overAllIdleDetect = on;
}

#include "idle.moc"
