//
// C++ Interface: kmfiptablesdocumentconverter
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFIPTABLESDOCUMENTCONVERTER_H
#define KMFIPTABLESDOCUMENTCONVERTER_H

/**
@author Christian Hubinger
*/

#include <qstring.h>
#include <qstringlist.h>

class KMFNetZone;
class KMFNetHost;
class IPTRule;
class IPTChain;
class IPTable;
class KMFIPTDoc;
class KMFProtocol;
class KMFGenericDoc;
class KMFErrorHandler;
class KMFError;


class KMFIPTablesDocumentConverter{
public:
    KMFIPTablesDocumentConverter();

    ~KMFIPTablesDocumentConverter();
	KMFIPTDoc* compileToIPTDoc( KMFGenericDoc* doc );

private:
	void addToChains( KMFNetZone*, KMFIPTDoc* , IPTChain*, const QString& );
	void createRules( KMFNetZone*, IPTChain*, const QString& );
	void setupConnectionTracking( KMFIPTDoc* );
	void setupPolicies( KMFGenericDoc*, KMFIPTDoc* );
	void createZoneProtocolRules( IPTChain*, KMFProtocol* );
	void createZoneProtocol( IPTChain*, KMFProtocol* prot , const QString& option, QStringList ports );
	void createHostProtocolRules( IPTChain*, KMFNetHost*, KMFProtocol*, const QString& );
	void createHostProtocol( IPTChain*, KMFNetHost*, KMFProtocol* prot , const QString& option, QStringList ports, const QString& );
	void setupInAndOutHosts( KMFIPTDoc*, KMFNetZone*,  const QString& );
	void setupForbiddenHosts( KMFIPTDoc*, KMFNetZone*, const QString&  );
	
	void setupICMPRules( KMFGenericDoc*, KMFIPTDoc* );
	
	void setupNatRules( KMFGenericDoc*, KMFIPTDoc* );
	void setupNatTarget( KMFGenericDoc*, IPTRule* );
	void setupLogging( KMFGenericDoc*, KMFIPTDoc* );
	void setupLoggingRules( KMFGenericDoc*, IPTChain* );

private: // DATA
	private: KMFGenericDoc *m_genericDoc;
	private: KMFErrorHandler *m_errorHandler;
	private: KMFError *m_err;
};

#endif
