/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/


#ifndef __kmfgenericinterface_part_h__
#define __kmfgenericinterface_part_h__

#include <klibloader.h>
#include <kparts/part.h>
#include <kparts/factory.h>

class KAboutData;
class KInstance;
class QLabel;
class KMFGenericInterface;

class KMFGenericInterfacePart: public KParts::ReadWritePart {
	Q_OBJECT
public:
	KMFGenericInterfacePart( QWidget *parent, const char *name, QObject *parent, const char *name,
	                         const QStringList & /*args*/ );
	virtual ~KMFGenericInterfacePart();
	static KAboutData *createAboutData();

	/**
	 * This is a virtual function inherited from KParts::ReadWritePart.
	 * A shell will use this to inform this Part if it should act
	 * read-only
	 */
	virtual void setReadWrite( bool rw );

	/**
	 * Reimplemented to disable and enable Save action
	 */
	virtual void setModified( bool modified );
public slots:
	void slotEnableActions( bool );

protected:
	/**
	 * This must be implemented by each part
	 */
	virtual bool openFile();

	/**
	 * This must be implemented by each read-write part
	 */
	virtual bool saveFile();

private:
	KMFGenericInterface *m_genericinterface;
/*signals:
	void sigUpdateView();*/
};

class KInstance;
class KAboutData;

class KMFGenericInterfacePartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    KMFGenericInterfacePartFactory();
    virtual ~KMFGenericInterfacePartFactory();
    virtual KParts::Part* createPartObject( QWidget *parentWidget, const char *widgetName,
                                            QObject *parent, const char *name,
                                            const char *classname, const QStringList &args );
    static KInstance* instance();

private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};
#endif


