/***************************************************************************
 begin                : Sat Mar 9 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfnewchaindlg.h"

// qt includes
#include <qstring.h>
#include <qradiobutton.h>
#include <qlineedit.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>

// my includes
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"
#include "../core/kmferror.h"
#include "../core/kmfcheckinput.h"
#include "../core/kmferrorhandler.h"

KMFNewChainDlg::KMFNewChainDlg( QWidget *parent, const char *name, bool modal, WFlags fl ) : KMyFirewallChainEditorNewChain( parent, name, modal, fl ) {
	kmfdoc = 0;
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMFNewChainDlg" );
	m_check_input = new KMFCheckInput();
}

KMFNewChainDlg::~KMFNewChainDlg() {}
void KMFNewChainDlg::loadDoc( KMFIPTDoc* doc ) {
	kmfdoc = doc;
}
/** No descriptions */
void KMFNewChainDlg::accept() {
	if ( kmfdoc == 0 ) {
		KMessageBox::error( 0, i18n( "KMFNewChainDlg: kmfdoc = 0. This happened because of a bug." ) );
		return ;
	}
	QStringList StringList;
	QString name = t_name->text();
	QString target = "DROP";

	m_check_input->checkInput( name, "CHAINNAME", m_err );
	if ( ! m_err_handler->showError( m_err ) ) {
		return;
	}

	if ( !name.isEmpty() ) {
		IPTChain* chain = 0;
		if ( c_filter->isChecked() ) {
			QString table = "filter";
			kmfdoc->startTransaction();
			kmfdoc->table( table )->saveState();
			chain = kmfdoc->table( table )->addChain( name, target, false, m_err );
			if ( m_err_handler->showError( m_err ) ) {
				kmfdoc->changed();
				emit sigUpdateView();
			} else {
				return;
			}
			kmfdoc->endTransaction();
			QDialog::accept();
		}
		if ( c_nat->isChecked() ) {
			QString table = "nat";
			kmfdoc->startTransaction();
			kmfdoc->table( table )->saveState();
			chain = kmfdoc->table( table )->addChain( name, target, false, m_err );
			if ( m_err_handler->showError( m_err ) ) {
				kmfdoc->changed();
				emit sigUpdateView();
			} else {
				return;
			}
			kmfdoc->endTransaction();
			QDialog::accept();
		}
		if ( c_mangle->isChecked() ) {
			QString table = "mangle";
			kmfdoc->startTransaction();
			kmfdoc->table( table )->saveState();
			chain = kmfdoc->table( table )->addChain( name, target, false, m_err );
			if ( m_err_handler->showError( m_err ) ) {
				kmfdoc->changed();
				emit sigUpdateView();
			} else {
				return;
			}
			kmfdoc->endTransaction();
			QDialog::accept();
		}
	} else {
		KMessageBox::sorry( 0, i18n( "You must set a name for your chain." ) );
		return;
	}
}


#include "kmfnewchaindlg.moc"
