/***************************************************************************
 begin                : Wed Aug 21 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfiptdocoptions.h"


// qt includes
#include <qcheckbox.h>

// kde includes
#include <kdebug.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <klocale.h>

// project includes
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"


KMFIPTDocOptions::KMFIPTDocOptions( QWidget *parent, const char *name ) : KMyFirewallIPTDocOptions( parent, name ) {}

KMFIPTDocOptions::~KMFIPTDocOptions() {}

void KMFIPTDocOptions::loadDoc( KMFIPTDoc* doc ) {
	kdDebug() << "void KMFIPTDocOptions::loadDoc(KMFIPTDoc* doc)" << endl;
	kmfdoc = doc;
	c_use_filter->setChecked( kmfdoc->useFilter() );
	c_use_nat->setChecked( kmfdoc->useNat() );
	c_use_mangle->setChecked( kmfdoc->useMangle() );
	c_use_ipfwd->setChecked( kmfdoc->useIPFwd() );
	c_use_rp_filter->setChecked( kmfdoc->useRPFilter() );
	c_use_martians->setChecked( kmfdoc->useMartians() );
	c_use_syn_cookies->setChecked( kmfdoc->useSynCookies() );
	c_use_modules->setChecked( kmfdoc->useModules() );
}
void KMFIPTDocOptions::accept() {
	if (  ! c_use_filter->isChecked() && ! c_use_nat->isChecked() && ! c_use_mangle->isChecked() ) {
		KMessageBox::sorry(this, i18n("<p>Sorry, you need to use at least one of the three tables -- <b> filter, nat</b> or <b>mangle</b>:<br>it does not make any sense to work on a ruleset where you cannot add any rules.</p>") );
		return;
	}

	kmfdoc->setUseFilter( c_use_filter->isChecked() );
	kmfdoc->setUseNat( c_use_nat->isChecked() );
	kmfdoc->setUseMangle( c_use_mangle->isChecked() );
	kmfdoc->setUseIPFwd( c_use_ipfwd->isChecked() );
	if ( c_use_rp_filter->isChecked() ) {
		kmfdoc->setUseRPFilter( true );
		kmfdoc->setUseMartians( c_use_martians->isChecked() );
	} else {
		kmfdoc->setUseRPFilter( false );
		kmfdoc->setUseMartians( false );
	}
	kmfdoc->setUseSynCookies( c_use_syn_cookies->isChecked() );
	kmfdoc->setUseModules( c_use_modules->isChecked() );
	kmfdoc->changed();
	emit sigConfigChanged();
	QDialog::accept();
}

void KMFIPTDocOptions::slotHelp() {
	kdDebug() << "void KMFIPTDocOptions::slotHelp() {" << endl;
	kapp->invokeHelp();
}


#include "kmfiptdocoptions.moc"

