/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/

#include "kmfruleeditip.h"
// qt includes
#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

// KDE includes
#include <kdebug.h>
#include <kapplication.h>

// project includes


#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmferror.h"
#include "../../core/kmfcheckinput.h"
#include "../../core/kmferrorhandler.h"



/*
 *  Constructs a KMFRuleEditIP which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KMFRuleEditIP::KMFRuleEditIP( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditorIP ( parent, name, fl ) {
	m_CheckInput = new KMFCheckInput();
	m_ErrorHandler = new KMFErrorHandler( "KMFRuleEditIP" );
	m_err = new KMFError();
}

/*
 *  Destroys the object and frees any allocated resources
 */
KMFRuleEditIP::~KMFRuleEditIP() {
	// no need to delete child widgets, Qt does it all for us
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEditIP::event( QEvent* ev ) {
	bool ret = QWidget::event( ev );
	if ( ev->type() == QEvent::ApplicationFontChange ) {}
	return ret;
}

void KMFRuleEditIP::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditIP::loadRule( IPTRule * rule )" << endl;
	c_src_ip->setChecked( false );
	c_dest_ip->setChecked( false );
	c_inv_src_ip->setChecked( false );
	c_inv_dest_ip->setChecked( false );
	t_src_ip->setText( "" );
	t_dest_ip->clear();
	m_rule = rule;

	IPTRuleOption* opt = 0;
	opt = m_rule->getOptionForName("ip_opt");
	if ( opt ) {
		QStringList args = opt->getValues();
		QString src, dest;
		src = *args.at(0);
		dest = *args.at(1);

		if ( !src.isEmpty() && src != "UNDEFINED" && src != "bool:off") {
			c_src_ip->setChecked( true );
			if ( src.startsWith( "! " ) ) {
				c_inv_src_ip->setChecked( true );
				t_src_ip->setText( src.right( src.length() - 2 ) );
			} else {
				t_src_ip->setText( src );
			}
		}
		if ( !dest.isEmpty() && dest != "UNDEFINED" && dest != "bool:off" ) {
			c_dest_ip->setChecked( true );
			if ( dest.startsWith( "! " ) ) {
				c_inv_dest_ip->setChecked( true );
				t_dest_ip->setText( dest.right( dest.length() - 2 ) );
			} else {
				t_dest_ip->setText( dest );
			}
		}

	}
	return ;
}


void KMFRuleEditIP::accept() {
	kdDebug() << "KMFRuleEditIP::slotOk()" << endl;
	m_rule->chain()->table()->kmfDoc()->startTransaction();
	m_rule->saveState();
	QString* src_ip = new QString( t_src_ip->text() );
	QString* dest_ip = new QString( t_dest_ip->text() );

	bool en_c_src_ip = c_src_ip->isChecked();
	bool en_c_dest_ip = c_dest_ip->isChecked();
	bool is_inv_src_ip = c_inv_src_ip->isChecked();
	bool is_inv_dest_ip = c_inv_dest_ip->isChecked();

	QString* option_name = new QString( "ip_opt" );
	QPtrList<QString>* args = new QPtrList<QString>;
	QPtrList<QString>* empty_args = new QPtrList<QString>;
	empty_args->append( new QString("bool:off") );
	empty_args->append(  new QString("bool:off") );
	emit sigAddRuleOpt( option_name, empty_args );

	if ( en_c_src_ip && !src_ip->isEmpty() ) {
		QString cmd = *src_ip;
		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( cmd, "IP/NETWORK/FQHN", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			m_rule->chain()->table()->kmfDoc()->endTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++

		if ( is_inv_src_ip ) {
			src_ip->prepend( "! " );
		}
		args->append( src_ip );
	} else {
		args->append( new QString("bool:off") );
	}

	if ( en_c_dest_ip && !dest_ip->isEmpty() ) {
		kdDebug() << "Add new dest_ip option" << endl;
		QString cmd = *dest_ip;
		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( cmd, "IP/NETWORK/FQHN", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			m_rule->chain()->table()->kmfDoc()->endTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		if ( is_inv_dest_ip ) {
			dest_ip->prepend( "! " );
		}
		args->append( dest_ip );
	}  else {
		args->append( new QString("bool:off") );
	}

	emit sigAddRuleOpt( option_name, args );
	m_rule->chain()->table()->kmfDoc()->endTransaction();
	emit sigHideMe();
	// QDialog::accept();
}

void KMFRuleEditIP::reject() {
	kdDebug() << "void KMFRuleEditIP::reject()" << endl;
	emit sigHideMe();
}

void KMFRuleEditIP::slotHelp() {
	kdDebug() << "void KMFRuleEditIP::slotHelp()" << endl;
	kapp->invokeHelp( "src_dest_ip" );
}





#include "kmfruleeditip.moc"
