/***************************************************************************
                          dlg_login.cpp  -  description
                             -------------------
    begin                : Sat Sep 29 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlg_login.moc"

dlg_login::dlg_login(QWidget *parent, const char *name, resource *rsrc) :
  KDialogBase(parent, name, TRUE, i18n("Login Prompt"), Help|Ok|Cancel, Ok,TRUE )
{
	serverList::Iterator i;
	serverList::Iterator currentServer;
	int counter = 0;

	myResource = rsrc;

  BOX_Parent = makeVBoxMainWidget();

	/* Select which server to connect to */
	GROUP_Select_Server = new QGroupBox( 1, Qt::Vertical, i18n( "Select Server" ), BOX_Parent );

	COMBO_Select_Server = new KComboBox ( GROUP_Select_Server );
	COMBO_Select_Server->setEditable( FALSE );

	/* fill the combobox with servers */
	for(i = myResource->servers.begin(); i != myResource->servers.end(); i++)
	{
		COMBO_Select_Server->insertItem((*i).Name);
		if((*i).CurrentRef == TRUE)
		{
    	COMBO_Select_Server->setCurrentItem(counter);
			currentServer = i;
		}
		counter++;
	}
	/* connect to right signal to the combobox */
	connect( COMBO_Select_Server, SIGNAL( activated(const QString &) ), this, SLOT( slotUpdateUser(const QString &) ) );

	GROUP_Username = new QGroupBox( 1, Qt::Horizontal, i18n("User info"), BOX_Parent);
	BOX_ALIGN = new QHBox( GROUP_Username );
  BOX_TEXT = new QVBox( BOX_ALIGN );
  TEXT_Login = new QLabel( BOX_TEXT );
  TEXT_Password = new QLabel( BOX_TEXT );

  TEXT_Login->setText( i18n("Login:") );
  TEXT_Password->setText( i18n("Password:") );

  BOX_EDIT = new QVBox( BOX_ALIGN );
  EDIT_Login = new KLineEdit( BOX_EDIT );
  EDIT_Password = new KLineEdit( BOX_EDIT );

  CHECKBOX_GUEST = new QCheckBox(i18n("Log in as guest"), GROUP_Username);

  EDIT_Password->setEchoMode( QLineEdit::Password );

  connect(CHECKBOX_GUEST, SIGNAL(toggled(bool)), this, SLOT(slotGuestToggle(bool)));

  /* Init the buttons */
  showButtonCancel( TRUE );
  showButtonOK( TRUE );
  showButton( Help, TRUE );

  enableButtonCancel( TRUE );
  enableButtonOK( TRUE );
  enableButton( Help, TRUE );
  setButtonOKText( i18n("Login"), i18n("Log in to the chess server using this name and password.") );
	setButtonCancelText(  i18n("Cancel"), i18n("Abort logging into the server") );
  setHelp("prefs");
  disableResize();
  show();
	/* make sure the username for the default server is displayed */
	slotUpdateUser((*currentServer).Name);
}
///////////////////////////////////////
//
//  dlg_login::~dlg_login
//
///////////////////////////////////////
dlg_login::~dlg_login()
{
}
///////////////////////////////////////
//
//  dlg_login::slotOk
//
///////////////////////////////////////
void dlg_login::slotOk( void )
{
  if(BOX_ALIGN->isEnabled())
  {
    emit login(EDIT_Login->text(), EDIT_Password->text());
  }
  else
  {
    emit login("guest", "");
  }
	emit okClicked();
  slotDelayedDestruct();
}

///////////////////////////////////////
//
//  dlg_login::slotGuestToggle
//
///////////////////////////////////////
void dlg_login::slotGuestToggle( bool on )
{
  BOX_ALIGN->setEnabled(!on);
}

///////////////////////////////////////
//
//  dlg_login::slotUpdateUser
//
///////////////////////////////////////
void dlg_login::slotUpdateUser(const QString &name)
{
	/* this function retrieves the correct serverResource from
		 the resources and uses that to fill in the username and
		 password fields */
	serverList::Iterator i;

	for(i = myResource->servers.begin(); i != myResource->servers.end(); i++)
	{
		if((*i).CurrentRef)
		{
    	(*i).CurrentRef = FALSE;
		}
		if((*i).Name == name )
		{
			(*i).CurrentRef = TRUE;
			EDIT_Login->setText((*i).UserName);
   		EDIT_Password->setText((*i).Password);
			server = &(*i);
		}
	}
}

///////////////////////////////////////
//
//  dlg_login::slotUpdateUser
//
///////////////////////////////////////
void dlg_login::disableServerSelect()
{
	COMBO_Select_Server->setEnabled(false);
}


