/***************************************************************************
                          tab_pgnview.cpp  -  description
                             -------------------
    begin                : Sat Jan 25 2003
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tab_pgnview.moc"
#include "tabmanager.h"
#include "resource.h"
#include "pgn.h"
#include <qfile.h>
#include <qregexp.h>
#include <qtextstream.h>
#include <kstddirs.h>
#include <ktempfile.h>

tab_pgnView::tab_pgnView(pgn *parent, resource *Rsrc ) : KnightsTextView(0,Rsrc)
{
	myParent = parent;
	whiteImage = NULL;
	blackImage = NULL;

	QString source = locate( "appdata", "pgn_template.kml" );
	QFile file( source );
	if( file.open( IO_ReadOnly ) )
	{
		QTextStream stream( &file );
		document = stream.read();
		file.close();
	}
	else
	{
		kdWarning() << "tab_pgnView::tab_pgnView: Can not find PGN Template" << endl;
	}
}

tab_pgnView::~tab_pgnView()
{
	if( whiteImage )
		delete whiteImage;
	if( blackImage )
		delete blackImage;
}
///////////////////////////////////////
//
//	tab_pgnView::init
//
///////////////////////////////////////
void tab_pgnView::init( void )
{
	/* Replace macros with data */
	document.replace( QRegExp( "%site%" ), myParent->TAG_Site );
	document.replace( QRegExp( "%date%" ), myParent->TAG_Date );
	document.replace( QRegExp( "%round%" ), myParent->TAG_Round );
	document.replace( QRegExp( "%result%" ), myParent->TAG_Result );
	document.replace( QRegExp( "%white%" ), myParent->TAG_White );
	document.replace( QRegExp( "%whitetitle%" ), myParent->TAG_WhiteTitle );
	document.replace( QRegExp( "%whiteelo%" ), myParent->TAG_WhiteElo );
	document.replace( QRegExp( "%whiteuscf%" ), myParent->TAG_WhiteUSCF );
	document.replace( QRegExp( "%whitena%" ), myParent->TAG_WhiteNA );
	document.replace( QRegExp( "%whitetype%" ), myParent->TAG_WhiteType );
	document.replace( QRegExp( "%black%" ), myParent->TAG_Black );
	document.replace( QRegExp( "%blacktitle%" ), myParent->TAG_BlackTitle );
	document.replace( QRegExp( "%blackelo%" ), myParent->TAG_BlackElo );
	document.replace( QRegExp( "%blackuscf%" ), myParent->TAG_BlackUSCF );
	document.replace( QRegExp( "%blackna%" ), myParent->TAG_BlackNA );
	document.replace( QRegExp( "%blacktype%" ), myParent->TAG_BlackType );
	document.replace( QRegExp( "%time%" ), myParent->TAG_Time );
	document.replace( QRegExp( "%utctime%" ), myParent->TAG_UTCTime );
	document.replace( QRegExp( "%utcdate%" ), myParent->TAG_UTCDate );
	document.replace( QRegExp( "%event%" ), myParent->TAG_Event );
	document.replace( QRegExp( "%eventdate%" ), myParent->TAG_EventDate );
	document.replace( QRegExp( "%eventsponsor"), myParent->TAG_EventSponsor );
	document.replace( QRegExp( "%section%" ), myParent->TAG_Section );
	document.replace( QRegExp( "%stage%" ), myParent->TAG_Stage );
	document.replace( QRegExp( "%board%" ), myParent->TAG_Board );
	document.replace( QRegExp( "%opening%" ), myParent->TAG_Opening );
	document.replace( QRegExp( "%variation%" ), myParent->TAG_Variation );
	document.replace( QRegExp( "%subvariation%" ), myParent->TAG_SubVariation );
	document.replace( QRegExp( "%eco%" ), myParent->TAG_ECO );
	document.replace( QRegExp( "%nic%" ), myParent->TAG_NIC );
	document.replace( QRegExp( "%timecontrol%" ), myParent->TAG_TimeControl );
	document.replace( QRegExp( "%termination%" ), myParent->TAG_Termination );
	document.replace( QRegExp( "%setup%" ), myParent->TAG_SetUp );
	document.replace( QRegExp( "%fen%" ), myParent->TAG_FEN );
	document.replace( QRegExp( "%annotator%" ), myParent->TAG_Annotator );
	document.replace( QRegExp( "%mode%" ), myParent->TAG_Mode );
	document.replace( QRegExp( "%plycount%" ), myParent->TAG_PlyCount );

	/* Get the White Player's Image */
	QPixmap wi = myResource->loadSCIDImage( myParent->TAG_White );
	if( wi.isNull() )
	{
		if( myParent->TAG_WhiteType == "program" )
			wi.load( locate("data", "knights/default-engine-portrait.jpg" ) );
		else
			wi.load( locate("data", "knights/default-portrait.jpg" ) );
	}
	whiteImage = new KTempFile();
	whiteImage->setAutoDelete( TRUE );
	wi.save( whiteImage->name(), "PNG" );
	document.replace( QRegExp( "%whiteimage%" ), whiteImage->name() );

	/* Get the Black Player's Image */
	QPixmap bi = myResource->loadSCIDImage( myParent->TAG_Black );
	if( bi.isNull() )
	{
		if( myParent->TAG_BlackType == "program" )
			bi.load( locate("data", "knights/default-engine-portrait.jpg" ) );
		else
			bi.load( locate("data", "knights/default-portrait.jpg" ) );
	}
	blackImage = new KTempFile();
	blackImage->setAutoDelete( TRUE );
	bi.save( blackImage->name(), "PNG" );
	document.replace( QRegExp( "%blackimage%" ), blackImage->name() );

	/* Obtain the move data */
	QString moves;
	QStringList *list;
	if( myParent->Move_Data.isEmpty() )
	{
		list = myParent->notation(2);
	}
	else
	{
		list = new QStringList( myParent->Move_Data );
	}

	/* Do some formatting and then merge the strings */
	for( QStringList::Iterator i = list->begin(); i != list->end(); i++ )
	{
		(*i).replace( QRegExp( "[^\\0040-\\0176]" ), "" );
		(*i).replace( QRegExp( "\\(" ), "<i>(" );
		(*i).replace( QRegExp( "\\)" ), ")</i>" );
		(*i).replace( QRegExp( "\\{" ), "<b>{" );
		(*i).replace( QRegExp( "\\}" ), "}</b>" );
	}
	moves = list->join( " " );
	delete list;

	int pos = document.find( "%moves%" );
	if( pos != -1 )
	{
		document.remove( (unsigned int)pos, 7 );
		document.insert( (unsigned int)pos, moves );
	}
	setText( document );
}
