<?php
/**
 * This Class inerhits functions that are used to handle hooks
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-hooks.php 222 2006-11-11 00:58:29Z lordlamer $
 */
class hooks {
	var $CLASS;
	
	var $hooks = array();
	
	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}
	
	/**
	 * set hook in a function and will run functions that are registered for this hook
	 */
	function setHook($classname,$functionname,$position) {
		if(isset($this->hooks[$classname][$functionname][$position]) && is_array($this->hooks[$classname][$functionname][$position])) {
			foreach($this->hooks[$classname][$functionname][$position] as $key => $value) {
				if(isset($this->hooks[$classname][$functionname][$position][$key]) && $this->hooks[$classname][$functionname][$position][$key] != "") {
					if(isset($this->CLASS[$key]) && is_object($this->CLASS[$key]) && $value != "") {
						if(method_exists($this->CLASS[$key],$value)) {
							$this->CLASS[$key]->$value();
						}
					} elseif(isset($this->CLASS['extension'][$key]) && is_object($this->CLASS['extension'][$key]['class']) && $value != "") {
						if(method_exists($this->CLASS['extension'][$key]['class'],$value)) {
							$this->CLASS['extension'][$key]['class']->$value();
						}
					}
				}
			}
		}
	}
	
	/**
	 * register a specific function in a class at a hook
	 */
	function execAtHook($classname,$functionname,$position,$myclass,$myfunction) {
		$this->hooks[$classname][$functionname][$position][$myclass] = $myfunction;
	}
}
?>