/***************************************************************************
                          socketserver.cpp  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <kapp.h>
#include <kdebug.h>

#include "socketserver.h"

Socketserver::Socketserver (QObject * parent, const char *name):QObject (parent,
	 name)
{
  timercount = 2;
  counter = 1;
  todocount = 0;
  timer = new QTimer (this);
  connect (timer, SIGNAL (timeout ()), this, SLOT (timerOut ()));

  iplist = new QList < struct ipcount >;
  iplist->setAutoDelete (true);	// delete items when they are removed

  socket_client = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  sock_unblock (socket_client);

  notify =
    new QSocketNotifier (socket_client, QSocketNotifier::Read,
			 (QObject *) this, "Socket");
  connect (notify, SIGNAL (activated (int)), this,
	   SLOT (incomming_request ()));
}

Socketserver::~Socketserver ()
{
  disconnect (notify, SIGNAL (activated (int)), this,
	      SLOT (incomming_request ()));
  if (notify != 0)
    delete notify;
  if (socket_client > 0)
    close (socket_client);

  if (iplist)
    {
      iplist->clear ();
      delete iplist;
    }
}

/** Diese Funktion nimmt die eingehenden Rufe an
und verarbeitet sie. */
void
Socketserver::incomming_request ()
{
  char buffer[1024];
  char machine[50];
  char workgroup[50];
  char master[50];
  bool ismaster = false;
  int count, maxcount;
  int i;
  u_long ip = 0;
  struct _nameinfo
  {
    char name[15];
    char type;
    char res;
    char fill;
  }
   *ninf;
  struct nmbhdr *nmb;
  bzero (buffer, sizeof (buffer));
  nmb = (struct nmbhdr *) buffer;
  i = read (socket_client, buffer, 1024);
  machine[0] = '\0';
  workgroup[0] = '\0';
  master[0] = '\0';
  if (i != 0)
    {
      if (nmb->rep_num != 0)
	{
	  /*set to first nameblock after header */
	  maxcount = (char) *(buffer + 56);
	  count = 0;
	  ninf =
	    (struct _nameinfo *) (buffer + 57 +
				  (count * sizeof (struct _nameinfo)));
	  while ((machine[0] == '\0')
		 && (57 + (count * sizeof (struct _nameinfo)) < 1024)
		 && (count < maxcount))
	    {
	      // Typ Workstation 0, Messenger Service/Main Name = 03, Server Service = 0x20
	      // Hier fehlte noch bit 1 von res (Maschine = 0, Workgroup = 1)
	      if ((ninf->type == 0) && ((ninf->res & 0x80) == 0))
		{
		  i = 0;
		  while ((i < 15))
		    {
		      machine[i] = ninf->name[i];
		      i++;
		    }
		  machine[i] = '\0';
		  trim (machine);
		}
	      ninf =
		(struct _nameinfo *) (buffer + 57 +
				      (count++ * sizeof (struct _nameinfo)));
	    }
	  if (machine[0] == '\0')
	    {
	      kdWarning (7199) <<
		"we finished without finding machine, giving up" << endl;
	      return;
	    }
	  while ((workgroup[0] == '\0')
		 && (57 + (count * sizeof (struct _nameinfo)) < 1024)
		 && (count < maxcount))
	    {
	      // Typ Workstation 0, Messenger Service/Main Name = 03, Server Service = 0x20
	      // Hier fehlte noch bit 1 von res (Maschine = 0, Workgroup = 1)
	      if ((ninf->type == 0) && ((ninf->res & 0x80) != 0))
		{
		  i = 0;
		  while ((i < 15))
		    {
		      workgroup[i] = ninf->name[i];
		      i++;
		    }
		  workgroup[i] = '\0';
		  trim (workgroup);
		}
	      ninf =
		(struct _nameinfo *) (buffer + 57 +
				      (count++ * sizeof (struct _nameinfo)));
	    }
	  if (workgroup[0] == '\0')
	    {
	      kdWarning (7199) <<
		"we finished without finding workgroup, giving up\n" << endl;
	      return;
	    }
	  while ((strcmp ("\1\2__MSBROWSE__\2\1", master))
		 && (57 + (count * sizeof (struct _nameinfo)) < 1024)
		 && (count < maxcount))
	    {
	      // Typ Workstation 0, Messenger Service/Main Name = 03, Server Service = 0x20
	      // Hier fehlte noch bit 1 von res (Maschine = 0, Workgroup = 1)
	      if ((ninf->type == 1) && ((ninf->res & 0x84) != 0))
		{
		  i = 0;
		  if (strncmp ("\1\2__MSBROWSE__\2", ninf->name, 15) == 0)
		    ismaster = true;
		}
	      ninf =
		(struct _nameinfo *) (buffer + 57 +
				      (count++ * sizeof (struct _nameinfo)));
	    }
	  if ((ip = getIP (nmb->id, true)) != 0)
	    {
	      todocount--;
	      emit insert_host (machine, workgroup, ip, ismaster);
	    }
	}
    }
}

/** Gibt socket zurck */
int
Socketserver::getsocket ()
{
  return socket_client;
}

void
Socketserver::getNMBInfo (u_long ip, unsigned short oldcount)
{
  struct sockaddr_in sin_dst;
  struct ipcount *ipcnt;
  struct nmbhdr *nmb;
  struct typez *typz;
  char *data;

  char buffer[51];
  int i;
  if ((oldcount == 0))
    {
      ipcnt = new ipcount;
      ipcnt->ip = ip;
      ipcnt->counter = counter;
      iplist->append (ipcnt);
    }
  // Erst mal buffer lschen
  bzero (buffer, sizeof (buffer));
  // Die NMB-Haeder-struktur zeigt auf den Anfang des Puffers,
  // damit kann bersichtlich in buffer geschieben werden
  nmb = (struct nmbhdr *) buffer;
  // Nach dem Header kommen die Daten (eigentlich nur der Netbui-Name "*")
  data = (char *) (buffer + NMBHDRSIZE);
  // Typenstructur am Ende der Daten
  typz = (struct typez *) (buffer + NMBHDRSIZE + 33);

  // Adresse des Empfngers zusammenstellen, Port ist natrlich immer der Netbui-Port
  sin_dst.sin_family = AF_INET;
  sin_dst.sin_port = htons (137);
  sin_dst.sin_addr.s_addr = htonl (ip);
  // Das heist auf Netbui "*", damit jeder Antwortet
  memcpy (data, "CKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 34);

  // Den Header fllen lt. RFC 1001/ 1002, in nmbhdr.h steht mehr dazu
  if (oldcount != 0)
    nmb->id = oldcount;
  else
    nmb->id = counter++;	/* Needed to look for the ip     */
  nmb->R = 0;			/* 0 for question 1 for response */
  nmb->opcode = 0;		/* 0 = query */
  nmb->que_num = htons (1);	/* i have only 1 question :) */
  nmb->namelen = 0x20;
  typz->type = 0x2100;
  typz->type2 = 0x0100;

  // Das Paket wird geschrieben, da es immer 50 Byte lang ist kann das auch hier hardcodiert rein
  i =
    sendto (socket_client, buffer, 50, 0, (struct sockaddr *) &sin_dst,
	    sizeof (sockaddr_in));
  if (oldcount == 0)
    if (todocount++)
      timer->start (1000, TRUE);
}

/* Entsperrt die Socket, funktioniert bei mir zwar auch ohne, aber vorsichtshalber */
void
Socketserver::sock_unblock (int s)
{
  int flag = O_NONBLOCK | fcntl (s, F_GETFL);
  fcntl (s, F_SETFL, flag);
}


/* Funktion trennt alle Space und Tabs vom hinteren Teil des Strings ab */
void
Socketserver::trim (char *str)
{

  int i;

  for (i = strlen (str) - 1; i >= 0; i--)
    if (str[i] != ' ' && str[i] != '\t')
      break;
  str[i + 1] = '\0';
}


/**  sucht die IP fr angegebenen counter  */
u_long Socketserver::getIP (unsigned short c, bool)
{
  u_long
    ip;
  if (iplist->first ())
    do
      {
	if (iplist->current ()->counter == c)
	  {
	    ip = iplist->current ()->ip;
	    iplist->remove ();
	    return ip;
	  }
      }
    while (iplist->next () != 0);
  return 0;
}


/**  */
void
Socketserver::timerOut ()
{
  if ((todocount > 0) && (timercount > 0))
    {
      timercount--;
      if (iplist->first () != 0)
	{
	  do
	    {
	      getNMBInfo (iplist->current ()->ip,
			  iplist->current ()->counter);
	    }
	  while (iplist->next () != 0);
	  timer->start (1000, TRUE);
	}
    }
  else
    emit isExited (this);
}
