
#include <kore/version.h>
#include <kore/plugin.h>
#include <iostream>

#define PLUGIN_MAJOR 0
#define PLUGIN_MINOR 0
#define PLUGIN_REVISION 1
#define PLUGIN_VERSION "0.0.1"
#define PLUGIN_API_MAJOR 0
#define PLUGIN_API_MINOR 0
#define PLUGIN_API_REVISION 1
#define PLUGIN_API_VERSION "0.0.1"
#define PLUGIN_NAME "Unknown Plugin"
#define PLUGIN_TYPE "Plugin"
#define PLUGIN_DESCRIPTION "Default/Unknown Plugin"

using namespace kore;

Plugin::Plugin()
{
    commonInit();
    _libHandle = 0;
    _libName = 0;
    _libPath = 0;
    _libFlags = 0;
}
Plugin::Plugin(HMODULE libhandle, const char* libname, const char* libpath, int flags)
{
    commonInit();
    _libHandle = libhandle;
    _libName = libname;
    _libPath = libpath;
    _libFlags = flags;
    //cout << "HMODULE: " << libhandle << endl;
}
Plugin::~Plugin()
{
    delete _pluginInfo;
    delete _pluginVersion;
    delete _pluginAPIVersion;
}
void Plugin::commonInit()
{
    _pluginVersion = new Version(PLUGIN_MAJOR,PLUGIN_MINOR,PLUGIN_REVISION,PLUGIN_VERSION);
    _pluginAPIVersion = new Version(PLUGIN_API_MAJOR,PLUGIN_API_MINOR,PLUGIN_API_REVISION,PLUGIN_API_VERSION);
    _pluginInfo = new Info(this, PLUGIN_NAME, PLUGIN_TYPE, PLUGIN_DESCRIPTION, _pluginVersion, _pluginAPIVersion);
    setInfo(_pluginInfo);
}
HMODULE Plugin::libHandle() const
{
    return _libHandle;
}

void Plugin::pluginLoaded()
{
	//cout << "Plugin::pluginLoaded()" << endl;
}
void Plugin::unloadingPlugin()
{
	//cout << "Plugin::unloadingPlugin()" << endl;
}

void Plugin::initPlugin()
{
}
void Plugin::finalizePlugin()
{
}
