
#include <kore/version.h>
#include <kore/servicemanager.h>
#include <kapp.h>
#include <kmessagebox.h>

#include "koredlg_kde.h"

#define KDK_MAJOR 0
#define KDK_MINOR 0
#define KDK_REVISION 1
#define KDK_VERSION "0.0.1"
#define KDK_API_MAJOR 0
#define KDK_API_MINOR 0
#define KDK_API_REVISION 2
#define KDK_API_VERSION "0.0.2"
#define KDK_NAME "KoreDialog <KDE>"
#define KDK_TYPE KOREDLG_TYPE
#define KDK_DESCRIPTION "KDE-based implementation for KoreDialog"
#define KDK_SERVICE KOREDLG_SERVICE "/kde"
#define KDK_SERVICE_DESCRIPTION "KDE-based '" KOREDLG_SERVICE "' service"

KoreDlg_kde::KoreDlg_kde()
{
    _kdkVersion = new Version(KDK_MAJOR,KDK_MINOR,KDK_REVISION,KDK_VERSION);
    _kdkAPIVersion = new Version(KDK_API_MAJOR,KDK_API_MINOR,KDK_API_REVISION,KDK_API_VERSION);
    _kdkInfo = new Info(this, KDK_NAME, KDK_TYPE, KDK_DESCRIPTION, _kdkVersion, _kdkAPIVersion);
    setInfo(_kdkInfo);
    _kdkService = new Service(this, KDK_SERVICE, KDK_SERVICE_DESCRIPTION);
    addService(_kdkService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDK_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_kde::~KoreDlg_kde()
{
    delete _kdkInfo;
    delete _kdkVersion;
    delete _kdkAPIVersion;
    delete _kdkService;
    delete _kdService;
}

void KoreDlg_kde::showMessage(const char *msg)
{
    int argc = 0;
    char* argv[] = {"",0};
//    QApplication app(argc,0);
//    QMessageBox::information( 0, KDK_NAME, msg);
    KApplication app( argc, argv, KDK_NAME );
    KMessageBox::information( 0, msg , KDK_NAME );
}
