
#include <kore/version.h>
#include <kore/servicemanager.h>
#include <qmessagebox.h>
#include <qapp.h>

#include "koredlg_qt.h"

#define KDQ_MAJOR 0
#define KDQ_MINOR 0
#define KDQ_REVISION 1
#define KDQ_VERSION "0.0.1"
#define KDQ_API_MAJOR 0
#define KDQ_API_MINOR 0
#define KDQ_API_REVISION 2
#define KDQ_API_VERSION "0.0.2"
#define KDQ_NAME "KoreDialog <Qt>"
#define KDQ_TYPE KOREDLG_TYPE
#define KDQ_DESCRIPTION "Qt-based implementation for KoreDialog"
#define KDQ_SERVICE KOREDLG_SERVICE "/qt"
#define KDQ_SERVICE_DESCRIPTION "Qt-based '" KOREDLG_SERVICE "' service"

KoreDlg_qt::KoreDlg_qt()
{
    _kdqVersion = new Version(KDQ_MAJOR,KDQ_MINOR,KDQ_REVISION,KDQ_VERSION);
    _kdqAPIVersion = new Version(KDQ_API_MAJOR,KDQ_API_MINOR,KDQ_API_REVISION,KDQ_API_VERSION);
    _kdqInfo = new Info(this, KDQ_NAME, KDQ_TYPE, KDQ_DESCRIPTION, _kdqVersion, _kdqAPIVersion);
    setInfo(_kdqInfo);
    _kdqService = new Service(this, KDQ_SERVICE, KDQ_SERVICE_DESCRIPTION);
    addService(_kdqService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDQ_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_qt::~KoreDlg_qt()
{
    delete _kdqInfo;
    delete _kdqVersion;
    delete _kdqAPIVersion;
    delete _kdqService;
    delete _kdService;
}

void KoreDlg_qt::showMessage(const char *msg)
{
    int argc = 0;
    QApplication app(argc,0);
    QMessageBox::information( 0, KDQ_NAME, msg);
}
