#ifndef KSIPOPTIONS_H_INCLUDED
#define KSIPOPTIONS_H_INCLUDED

#include <qdialog.h>

#include "../dissipate2/sipclient.h"

class SipUser;
class SipCall;
class SipCallMember;
class QLineEdit;
class QMultiLineEdit;

class KSipOptions : public QDialog
{
	Q_OBJECT
public:
	KSipOptions( SipUser *user, QWidget *parent = 0, const char *name = 0 );
	~KSipOptions( void );

private slots:
	void queryOptions( void );
	void optionsCallStatusUpdated( void );

private:
	SipUser *u;
	SipCall *call;
	SipCallMember *member;
	QLineEdit *queryuri;
	QMultiLineEdit *qresults;
};

class KTestOptions : public QDialog
{
	Q_OBJECT
public:
	KTestOptions( SipClient *client );
	~KTestOptions( void );

public slots:
	void testSendMessage( void );

protected slots:
	void slotOk( void );

private slots:
	void testClean( void );
	void testFile( void );
	void testSend( void );

private:
	SipClient *c;
	QLineEdit *addr;
	QLineEdit *port;
	QMultiLineEdit *msg;
	QString testStr;
};


#endif // KSIPOPTIONS_H_INCLUDED
