//
// C++ Implementation: kpgdomainsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainsfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgdomain.h"


KPGDomainsFolder::KPGDomainsFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
 : KPGItemsFolder(parent, i18n("Domains"))
{
	m_oidNameSpace = oidNameSpace;
}


KPGDomainsFolder::~KPGDomainsFolder()
{
}

void KPGDomainsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items 
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
        // obtain list of domains
    QString strQuery("SELECT d.oid, d.typname as domname, description, b.oid AS basetypeoid, b.typname as basetype, d.typlen, d.typnotnull, d.typdefault, d.typndims, d.typdelim, \
    pg_get_userbyid(d.typowner) as owner ");
	strQuery.append("FROM pg_catalog.pg_type d ");
	strQuery.append("JOIN pg_catalog.pg_type b ON b.oid = CASE WHEN d.typndims > 0 THEN d.typelem ELSE d.typbasetype END ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=d.oid ");
	strQuery.append("WHERE d.typtype = 'd' ");
	strQuery.append("AND d.typnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY d.typname");
			
    try
    {
        m_pqxxResultDomains = connection()->runQuery(strQuery);
    
        KPGDomain *pDomain = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultDomains.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultDomains[i][0].to(oid);
            
            if(pDomain == 0)
                pDomain = new KPGDomain(this, m_pqxxResultDomains[i]["domname"].c_str(), oid);
            else
                pDomain = new KPGDomain(this, pDomain, m_pqxxResultDomains[i]["domname"].c_str(), oid);
            
            pDomain->setProperties(m_pqxxResultDomains[i]);
            pDomain->refreshConstraints(); 
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 

}

