//
// C++ Implementation: kpgschema
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgschema.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <kcursor.h>

#include "kpgdatabase.h"
#include "kpgserver.h"
#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "kpgconnection.h"
#include "kpgtablesfolder.h"
#include "kpgviewsfolder.h"
#include "kpgsequencesfolder.h"
#include "kpgfunctionsfolder.h"
#include "kpgoperatorsfolder.h"
#include "kpgoperatorclassesfolder.h"
#include "kpgaggregatesfolder.h"
#include "kpgdomainsfolder.h"
#include "kpgtypesfolder.h"
#include "kpgconversionsfolder.h"

#include "../kpgsqldialog.h"


KPGSchema::KPGSchema(KPGDatabase *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
    m_bIsLoaded = false;
    setPixmap(0, *m_pIconSchemaUnl);
  
    if((name.left(3) == "pg_") || (name == "information_schema"))
        m_bIsSystemObject = true;
    else
        m_bIsSystemObject = false;
  
    m_pFolderViews = new KPGViewsFolder(this, _oid);
    m_pFolderSequences = new KPGSequencesFolder(this, _oid);
    m_pFolderTypes = new KPGTypesFolder(this, _oid);
    m_pFolderTables = new KPGTablesFolder(this, _oid);
    m_pFolderOperatorClasses = new KPGOperatorClassesFolder(this, _oid);
	m_pFolderOperators = new KPGOperatorsFolder(this, _oid);
    m_pFolderFunctions = new KPGFunctionsFolder(this, _oid);
    m_pFolderDomains = new KPGDomainsFolder(this, _oid);
	m_pFolderConversions = new KPGConversionsFolder(this, _oid);
	m_pFolderAggregates = new KPGAggregatesFolder(this, _oid);
}

KPGSchema::KPGSchema(KPGDatabase *parent, KPGSchema *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
    m_bIsLoaded = false;
    setPixmap(0, *m_pIconSchemaUnl);
    
    if((name.left(3) == "pg_") || (name == "information_schema"))
            m_bIsSystemObject = true;
    else
        m_bIsSystemObject = false;
  	
	m_pFolderViews = new KPGViewsFolder(this, _oid);
    m_pFolderSequences = new KPGSequencesFolder(this, _oid);
    m_pFolderTypes = new KPGTypesFolder(this, _oid);
    m_pFolderTables = new KPGTablesFolder(this, _oid);
    m_pFolderOperatorClasses = new KPGOperatorClassesFolder(this, _oid);
    m_pFolderOperators = new KPGOperatorsFolder(this, _oid);
    m_pFolderFunctions = new KPGFunctionsFolder(this, _oid);
    m_pFolderDomains = new KPGDomainsFolder(this, _oid);
    m_pFolderConversions = new KPGConversionsFolder(this, _oid);
    m_pFolderAggregates = new KPGAggregatesFolder(this, _oid);
}

KPGSchema::~KPGSchema()
{
}

void KPGSchema::activate()
{
	if(!m_bIsLoaded)
	{ 
		listView()->setCursor(KCursor::waitCursor());
		
		try
		{
			refresh();
		}
		catch (const KPGSqlException &e)
		{
			listView()->setCursor(KCursor::arrowCursor());
			KPGSqlDialog dlg(0, e.getSql(), e.what());
			dlg.exec();
		}
		listView()->setCursor(KCursor::arrowCursor());
		setOpen(true);
	}
}


void KPGSchema::refresh() throw(const KPGSqlException &)
{	
	m_pFolderTables->refresh();
	m_pFolderViews->refresh();
	m_pFolderFunctions->refresh();
	m_pFolderSequences->refresh();
	m_pFolderOperators->refresh();
	m_pFolderOperatorClasses->refresh();
	m_pFolderAggregates->refresh();
	m_pFolderDomains->refresh();
	m_pFolderTypes->refresh();
	m_pFolderConversions->refresh();
				
    m_bIsLoaded = true;
  
    if(m_bIsSystemObject)
        setPixmap(0, *m_pIconSchemaSys);
    else
        setPixmap(0, *m_pIconSchemaUsr);
}

// Refresh only schema info, without childs objects
void KPGSchema::refreshItem() throw(const KPGSqlException &)
{
    // Get pointer to server for version info
    //KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent());
    //KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
    
    // obtain schema
    QString strQuery("SELECT nsp.nspname, description, nspacl, has_schema_privilege(nsp.oid, 'CREATE') as cancreate, pg_get_userbyid(nspowner) AS owner ");
    
    strQuery.append("FROM pg_catalog.pg_namespace nsp ");
    strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=nsp.oid ");
    
    strQuery.append("WHERE nsp.oid = " + QString("%1").arg(m_oid));
        
    try
    {
        pqxx::result pqxxResultSchemas = connection()->runQuery(strQuery);
    
        if(pqxxResultSchemas.size() != 1)
        {
            kdError() << k_funcinfo "Expect one row in result !" <<  endl;
            return;
        }
        
        setProperties(pqxxResultSchemas[0]);
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}


void KPGSchema::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	m_strOwner = pqxxTuple["owner"].c_str();
	pqxxTuple["cancreate"].to(m_bCanCreate);
	m_strACL = pqxxTuple["nspacl"].c_str();
	m_strDescription = pqxxTuple["description"].c_str();
}

const pqxx::result & KPGSchema::resultAggregates() const
{
	return m_pFolderAggregates->resultAggregates();
}

const pqxx::result & KPGSchema::resultConversions() const
{
	return m_pFolderConversions->resultConversions();
}

const pqxx::result & KPGSchema::resultDomains() const
{
	return m_pFolderDomains->resultDomains();
}

const pqxx::result & KPGSchema::resultFunctions() const
{
	return m_pFolderFunctions->resultFunctions();
}

const pqxx::result & KPGSchema::resultOperatorClasses() const
{
	return m_pFolderOperatorClasses->resultOperatorClasses();
}

const pqxx::result & KPGSchema::resultOperators() const
{
	return m_pFolderOperators->resultOperators();
}

const pqxx::result & KPGSchema::resultSequences() const
{
	return m_pFolderSequences->resultSequences();
}

const pqxx::result & KPGSchema::resultTables() const
{
	return m_pFolderTables->resultTables();
}

const pqxx::result & KPGSchema::resultTypes() const
{
	return m_pFolderTypes->resultTypes();
}

const pqxx::result & KPGSchema::resultViews() const
{
	return m_pFolderViews->resultViews();
}

void KPGSchema::fillListOfObjectsForCodeCompletion(KPGOidNameList & listOfObjectOids)
{
    m_pFolderTables->fillListOfObjectOidsWithChildItems(listOfObjectOids);
	m_pFolderViews->fillListOfObjectOidsWithChildItems(listOfObjectOids);
	m_pFolderFunctions->fillListOfObjectOidsWithChildItems(listOfObjectOids);
}
