/***************************************************************************
                          kpgtablecolumn  -  description
                             -------------------
    begin                : So no 7 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGTABLECOLUMN_H
#define KPGTABLECOLUMN_H

#include "kpgtreeitem.h"

class KPGTableColumnsFolder;

/**
  * Table column
  *
  * @author Lumir Vanek
  */
class KPGTableColumn : public KPGTreeItem
{
public:
	KPGTableColumn(KPGTableColumnsFolder *, const QString);
	KPGTableColumn(KPGTableColumnsFolder *, KPGTableColumn *, const QString);
  	~KPGTableColumn();
  
	virtual eNodeType type() const { return nodeTableColumn; }
  	
  	void setProperties(const pqxx::result::tuple &);
  	
  	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
  	
  	static QPixmap *getPixmapForType(const QString &);
  	
  	/*
	 * Functions for accessing properties
	 */
  	pqxx::oid oidType() const { return m_oidType; }
  	pqxx::oid oidBaseType() const { return m_oidBaseType; }
	const QString & typName() const { return m_strTypName; }
	long statTarget() const { return m_lStatTarget; }
	int attLen() const { return m_iAttLen; }
	int attNum() const { return m_iAttNum; } 
	int attNdims() const { return m_iAttNdims; }
	int attTypmod() const { return m_iAttTypmod; }
	bool byValue() const { return m_bByVal; }
	bool hasDefault() const { return m_bHasDef; }
	bool isNotNull() const { return m_bNotNull; }
	bool isDropped() const { return m_bIsDropped; }
	bool isLocal() const { return m_bIsLocal; }
	const QString & defaultValue() const { return m_strAdSrc; }
	const QString & storage() const { return m_strStorage; }
	const QString & description() const { return m_strDescription; }
	int inhCount() const { return m_iInhCount; }
	const QString & nspName() const { return m_strNspName; }
	
	const QString createdAs() const;
	
protected:

	/*
	 * Properties
	 */
	pqxx::oid m_oidType;
  	pqxx::oid m_oidBaseType;
	QString m_strTypName;
	QString m_strDescription;
	long m_lStatTarget;
	int m_iAttLen;
	int m_iAttNum; 
	int m_iAttNdims;
	int m_iAttTypmod;
	bool m_bByVal;
	bool m_bNotNull;
	bool m_bHasDef;
	bool m_bIsDropped;
	bool m_bIsLocal;
  	QString m_strStorage;
	int m_iInhCount;
	QString m_strAdSrc;
	QString m_strNspName;
};

#endif
