/***************************************************************************
                          kpgtablesfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGTABLESFOLDER_H
#define KPGTABLESFOLDER_H

#include "kpgitemsfolder.h"

class KPGSchema;


/**
  * Folder that holds tables list
  * 
  * @author Lumir Vanek
  */
class KPGTablesFolder : public KPGItemsFolder
{
public:
    KPGTablesFolder(KPGSchema *, pqxx::oid);
    ~KPGTablesFolder();
		
	virtual eNodeType type() const { return nodeFolderTables; }
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	
	const pqxx::result & resultTables() const { return m_pqxxResultTables; }
	
	virtual void fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids);
			
protected:
  	// results that will be displaied in properties window
  	pqxx::result m_pqxxResultTables; 
	
	// Parent namespace OID
	pqxx::oid m_oidNameSpace;
};

#endif
