//
// C++ Implementation: kpgdebuggerchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdebuggerchildview.h"

#include <qlayout.h>

// include files for KDE
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "kpgdebugger.h"
#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgfunction.h"

KPGDebuggerChildView::KPGDebuggerChildView(KPoGreView *pPoGreView,
	KParts::Factory* pKatePartFactory,
	KXMLGUIFactory * pXmlGuiFactory,
	KPGConnection * pConnection, 
	const QString & strNamespace, 
	KPGFunction *pFunction
	)
 : KMdiChildView(i18n("Debugger"), pPoGreView, "KPGExecutorChildView")
{
	m_pPoGreView = pPoGreView;
	
	QBoxLayout* pLayout = new QHBoxLayout(this, 0, -1, "layout" );
	m_pDebugger = new KPGDebugger(this, 
		pPoGreView,
		pKatePartFactory,
		pXmlGuiFactory,
		pConnection, 
		strNamespace, 
		pFunction);

	pLayout->addWidget(m_pDebugger);
	
	setIcon(SmallIcon("kpg_debugger"));
}


KPGDebuggerChildView::~KPGDebuggerChildView()
{
}

// Add QueryResultChildView and its Kate GUI client to factory
void KPGDebuggerChildView::slotActivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pDebugger->addToGuiFactory();
}

// Remove QueryResultChildView and its Kate GUI client from factory
void KPGDebuggerChildView::slotDeactivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pDebugger->removeFromGuiFactory();
}

bool KPGDebuggerChildView::requestClose()
{
	if(KMessageBox::questionYesNo(this, i18n("Really close debugger window ?")) == KMessageBox::Yes) 
	{
		return true;
	}
	return false;
}


