//
// C++ Interface: kpgkatexmleditordialog
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGKATEXMLEDITORDIALOG_H
#define KPGKATEXMLEDITORDIALOG_H

#include "kpgkatexmleditordialogbase.h"

#include <kparts/factory.h> // KPart Factory
#include <kate/view.h>      // Katepart view

#include <kxmlguibuilder.h>

class KPoGreView;


/**
  * Dialog for editing XML as raw text using Kate part
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGKateXmlEditorDialog : public KPGKateXmlEditorDialogBase, public KXMLGUIBuilder, virtual public KXMLGUIClient
{
	Q_OBJECT
public:
    KPGKateXmlEditorDialog(KPoGreView *, KParts::Factory*);
    ~KPGKateXmlEditorDialog();
    
    // Set editor text
    void setEditorText(const QString &, bool);
    
    // Get editor text
    const QString editorText() const;
    
protected:
    
	// Kate part editor
    Kate::View* m_pKateView;
    
    // XML GUI factory
    KXMLGUIFactory * m_pXmlGuiFactory;
    
    // Is edited text XML ?
    bool m_bIsXml;
    
protected:

	// Create Kate part view
	Kate::View * createKatePart(KParts::Factory*);

	bool validateXml(bool);
  
  	virtual void virtual_hook( int id, void* data );
  
protected slots:
	
	// Kate documents signals handling
  	virtual void slotTextChanged();
	
	// Fired, when user press Validate button
  	virtual void slotValidate();

	// Fired, when user press OK button
	virtual void accept();
};

#endif
