//
// C++ Implementation: kpglanguagesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpglanguagesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>


#include "../kpgutil.h"
#include "../DbObjects/kpglanguagesfolder.h"
#include "../DbObjects/kpgconnection.h"

KPGLanguagesFolderPropPage::KPGLanguagesFolderPropPage(QWidget *pParent, KPGLanguagesFolder *pLanguagesFolder)
 : KPGPropertyPage(pParent, "KPGLanguagesFolderPropPage")
{
	m_pLanguagesFolder = pLanguagesFolder;
	displayProperties();
}


KPGLanguagesFolderPropPage::~KPGLanguagesFolderPropPage()
{
}

void KPGLanguagesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Languages &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

    int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
    pHeader->setLabel(nCol++, i18n("Is Trusted"));
	pHeader->setLabel(nCol++, i18n("ACL"));
	pHeader->setLabel(nCol++, i18n("Language Function"));
	pHeader->setLabel(nCol++, i18n("Language Validator"));

	QTextCodec * pTextCodec = m_pLanguagesFolder->connection()->textCodec();
	
    KPGUtil::fillPropertiesTable(m_pLanguagesFolder->resultLanguages(), m_pTableItems, pTextCodec);
}


