//
// C++ Interface: kpg7stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPG7STEPSWIZARD_H
#define KPG7STEPSWIZARD_H


#include "kpg7stepswizardbase.h"

class KPGSyntaxHighlighter;
class KPGConnection;

/**
  * Wizard with 7 steps
  *
  * @author Lumir Vanek
  */
class KPG7StepsWizard : public KPG7StepsWizardBase
{
	Q_OBJECT
public:
    KPG7StepsWizard(QWidget *parent, const char *name);
    ~KPG7StepsWizard();
		
	// Set connection to database
	void setConnection(KPGConnection *);

	// Return connection
    KPGConnection * connection() const { return m_pConnection; }
		
	QWidget * pageWidget1() { return m_pPageWidget1; }
	QWidget * pageWidget2() { return m_pPageWidget2; }
	QWidget * pageWidget3() { return m_pPageWidget3; }
	QWidget * pageWidget4() { return m_pPageWidget4; }
	QWidget * pageWidget5() { return m_pPageWidget5; }

protected:
    // Run SQL query - as final Wizard operation
    void runQuery(bool = true);    
    			
protected:
	QWidget *m_pPageWidget1;
	QWidget *m_pPageWidget2;
	QWidget *m_pPageWidget3;
	QWidget *m_pPageWidget4;
	QWidget *m_pPageWidget5;
		
private:  
	
    // Connection to database
	KPGConnection *m_pConnection;
		
  	// Syntax highlighter for m_pTextEditSQL
  	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	
	// Noticications list
	QStringList m_listOfNotifications;
				
protected slots:
	
	// Enable/disable next button for 1st page
	void slotEnableNextButton1(bool);

	// Enable/disable next button for 2nd page
	void slotEnableNextButton2(bool);
		
	// Enable/disable next button for 3rd page
	void slotEnableNextButton3(bool);
		
	// Enable/disable next button for 4th page
	void slotEnableNextButton4(bool);
		
	// Enable/disable next button for 5th page
	void slotEnableNextButton5(bool);
			
	// Process notice from connection
    void slotProcessNotice(const QString &);
};

#endif
