//
// C++ Implementation: kpgcreatetableindexwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetableindexwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kactionselector.h> 
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgcreatetablewidget4.h"


KPGCreateTableIndexWizard::KPGCreateTableIndexWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable)
 : KPG3StepsWizard(parent, name)
{
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
  
	KPGCreateTableWidget4 *pCreateTableWidget4 = new KPGCreateTableWidget4(WizardPage1, "KPGCreateTableWidget4", pDatabase);
	m_pPageWidget1 = pCreateTableWidget4;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateTableWidget4, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
	// setup initial state for KPGCreateTableWidget3
  	pTable->getTableColumnsFolder()->fillListBoxWithChildItems(pCreateTableWidget4->m_pActionSelectorIDXColumns->availableListBox(), false);
	pTable->getTableColumnsFolder()->fillListColumnWizInfoWithChildItems(pCreateTableWidget4->getListOfAvailableColumns());
	
	pCreateTableWidget4->setNamespace(pSchema->text(0));
  	pCreateTableWidget4->setTableName(pTable->text(0));
  
	if(pServer->versionMajor() >= 8)
		pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateTableWidget4->m_pComboBoxTablespace);
	else
		pCreateTableWidget4->m_pComboBoxTablespace->setEnabled(false);
				
	languageChange();
}


KPGCreateTableIndexWizard::~KPGCreateTableIndexWizard()
{
}

void KPGCreateTableIndexWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Add Index to Table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Define table indexes" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTableIndexWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    KPGCreateTableWidget4 *pCreateTableWidget4 = static_cast <KPGCreateTableWidget4 *> (m_pPageWidget1);
    
    // prepare SQL statement
    QString strSQL;
    
    QListViewItem * pItem = pCreateTableWidget4->m_pListViewIndexes->firstChild();
    while(pItem)
    {
      strSQL.append(pItem->text(0));
      strSQL.append(";\n");
      
      pItem = pItem->nextSibling();
    }
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreatetableindexwizard.moc"
