//
// C++ Implementation: kpgcreateviewwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateviewwizard.h"

// include files for Qt
#include <qlayout.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreateviewwidget1.h"
#include "kpgcreateviewwidget2.h"
#include "kpgcreateviewwidget3.h"
#include "kpgcreateviewwidget4.h"


KPGCreateViewWizard::KPGCreateViewWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPG6StepsWizard(parent, name)
{
	KPGCreateViewWidget1 *pCreateViewWidget1 = new KPGCreateViewWidget1(WizardPage1, "KPGCreateViewWidget1", pDatabase, listOfSchemas);
	m_pPageWidget1 = pCreateViewWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateViewWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	KPGCreateViewWidget2 *pCreateViewWidget2 = new KPGCreateViewWidget2(WizardPage2, "KPGCreateViewWidget2", pDatabase);
	m_pPageWidget2 = pCreateViewWidget2;
	WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
	connect(pCreateViewWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
	
	KPGCreateViewWidget3 *pCreateViewWidget3 = new KPGCreateViewWidget3(WizardPage3, "KPGCreateViewWidget3", pDatabase);
	m_pPageWidget3 = pCreateViewWidget3;
	WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
	connect(pCreateViewWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton3(bool)));
	
	KPGCreateViewWidget4 *pCreateViewWidget4 = new KPGCreateViewWidget4(WizardPage4, "KPGCreateViewWidget4", pDatabase);
	m_pPageWidget4 = pCreateViewWidget4;
	WizardPage4Layout->addWidget(m_pPageWidget4, 0, 0);
	connect(pCreateViewWidget4, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton4(bool)));
  	
	languageChange();
}


KPGCreateViewWizard::~KPGCreateViewWizard()
{
}

void KPGCreateViewWizard::languageChange()
{
    KPG6StepsWizard::languageChange();
		
	setCaption( i18n( "Create new View" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - View name and used tables list" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Define columns" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Define joins" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Define conditions" ) );
    setTitle( WizardPage5, i18n( "Step 5 - Review SQL statement" ) );
    setTitle( WizardPage6, i18n( "Step 6 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateViewWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage1) // Step 1 - Define view tables
	{
		//--- Initialize 1st page
		KPGCreateViewWidget1 *pCreateViewWidget1 = static_cast <KPGCreateViewWidget1 *> (m_pPageWidget1);

		if(pCreateViewWidget1->m_pListBoxAvailTables->count() == 0)
		  pCreateViewWidget1->refreshAvailTablesList(pCreateViewWidget1->m_pComboBoxSchema->currentText()); 
	}
	
		
	if(pPage == WizardPage2) // Step 2 - Define view columns
	{
		//--- Initialize 2nd page
		KPGCreateViewWidget1 *pCreateViewWidget1 = static_cast <KPGCreateViewWidget1 *> (m_pPageWidget1);
		KPGCreateViewWidget2 *pCreateViewWidget2 = static_cast <KPGCreateViewWidget2 *> (m_pPageWidget2);
		
		// set selected namespace
		pCreateViewWidget2->setNamespace(pCreateViewWidget1->m_pComboBoxSchema->currentText());
				
		if(pCreateViewWidget1->isDirty1())
		{
			// Fill tables list from 1st page
			pCreateViewWidget2->m_pComboBoxTables->clear();
			
			unsigned int i = 0; 
			QListViewItem * pItem = pCreateViewWidget1->m_pListViewTables->firstChild();
			MapTableNameAlias mapTableNameAlias;
			while(pItem)
			{
				mapTableNameAlias[pItem->text(0)] = pItem->text(1);
				
				pCreateViewWidget2->m_pComboBoxTables->insertItem(
					* pItem->pixmap(0),
					pItem->text(0)
					);
					
				if(i++ == 0)
					pCreateViewWidget2->refreshAvailColumnsList(pItem->text(0));
					
				pItem = pItem->nextSibling();
			}
			
			pCreateViewWidget2->setMapTableNameAlias(mapTableNameAlias);
			pCreateViewWidget1->clearDirty1();
		}
	}
	
	if(pPage == WizardPage3) // Step 2 - Define joins
	{
		//--- Initialize 2nd page
		KPGCreateViewWidget1 *pCreateViewWidget1 = static_cast <KPGCreateViewWidget1 *> (m_pPageWidget1);
		KPGCreateViewWidget3 *pCreateViewWidget3 = static_cast <KPGCreateViewWidget3 *> (m_pPageWidget3);
		
		// set selected namespace
    	pCreateViewWidget3->setNamespace(pCreateViewWidget1->m_pComboBoxSchema->currentText());
		
		if(pCreateViewWidget1->isDirty2())
		{
			// Fill tables list from 1st page
			pCreateViewWidget3->m_pComboBoxLeftTables->clear();
			pCreateViewWidget3->m_pComboBoxRightTables->clear();
			
			unsigned int i = 0; 
			QListViewItem * pItem = pCreateViewWidget1->m_pListViewTables->firstChild();
			MapTableNameAlias mapTableNameAlias;
			while(pItem)
			{
				mapTableNameAlias[pItem->text(0)] = pItem->text(1);
				
				// Left tables
				pCreateViewWidget3->m_pComboBoxLeftTables->insertItem(
					* pItem->pixmap(0),
					pItem->text(0)
					);
					
				if(i == 0)
					pCreateViewWidget3->refreshAvailColumnsList(pItem->text(0), false);
					
				// Right tables
				pCreateViewWidget3->m_pComboBoxRightTables->insertItem(
					* pItem->pixmap(0),
					pItem->text(0)
					);
					
				if(i == 0)
					pCreateViewWidget3->refreshAvailColumnsList(pItem->text(0), true);
					
				i++;
				pItem = pItem->nextSibling();
			}
			
			pCreateViewWidget3->setMapTableNameAlias(mapTableNameAlias);
			pCreateViewWidget1->clearDirty2();
		}
	}
	
	if(pPage == WizardPage4) // Step 4 - Define view conditions
	{
		//--- Initialize 2nd page
		KPGCreateViewWidget1 *pCreateViewWidget1 = static_cast <KPGCreateViewWidget1 *> (m_pPageWidget1);
		KPGCreateViewWidget4 *pCreateViewWidget4 = static_cast <KPGCreateViewWidget4 *> (m_pPageWidget4);
	
		// set selected namespace
    	pCreateViewWidget4->setNamespace(pCreateViewWidget1->m_pComboBoxSchema->currentText());
		
		if(pCreateViewWidget1->isDirty3())
		{
			// Fill tables list from 1st page
			pCreateViewWidget4->m_pComboBoxTables->clear();
			
			unsigned int i = 0; 
			QListViewItem * pItem = pCreateViewWidget1->m_pListViewTables->firstChild();
			MapTableNameAlias mapTableNameAlias;
			while(pItem)
			{
				mapTableNameAlias[pItem->text(0)] = pItem->text(1);
				
				pCreateViewWidget4->m_pComboBoxTables->insertItem(
					* pItem->pixmap(0),
					pItem->text(0)
					);
					
				if(i++ == 0)
					pCreateViewWidget4->refreshAvailColumnsList(pItem->text(0));
					
				pItem = pItem->nextSibling();
			}
			
			pCreateViewWidget4->setMapTableNameAlias(mapTableNameAlias);
			pCreateViewWidget1->clearDirty3();
		}
	}
	
	if(pPage == WizardPage5) // Step 5 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL;
		
		strSQL.append((static_cast <KPGCreateViewWidget1 *> (m_pPageWidget1))->getSQL());
		strSQL.append(" AS\nSELECT ");
		
		strSQL.append((static_cast <KPGCreateViewWidget2 *> (m_pPageWidget2))->getSQL());
		strSQL.append("\nFROM ");
		strSQL.append((static_cast <KPGCreateViewWidget3 *> (m_pPageWidget3))->getSQL());
		
		strSQL.append((static_cast <KPGCreateViewWidget4 *> (m_pPageWidget4))->getSQL());
				
		strSQL.append(";");
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage6) // Step 6 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG6StepsWizard::showPage(pPage);
}

#include "kpgcreateviewwizard.moc"
