/***************************************************************************
                          itemxmlfactory.cpp  -  description
                             -------------------
    begin                : Sat Sep 6 2003
    copyright            : (C) 2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "itemxmlfactory.h"

itemXMLfactory::itemXMLfactory(QString _title, QString _content, Type _type, Position _pos){
	title = _title;
	content = _content;
	type = _type;
	pos = _pos;
}

itemXMLfactory::~itemXMLfactory(){
}

QDomDocument itemXMLfactory::getDocument(){
	qdd = QDomDocument ("item");
	make();
	qdd . appendChild (item);
	return qdd;
}

QDomDocumentFragment itemXMLfactory::getFragment( QDomDocument _qdd ){
	qdd = _qdd;
	make();
	QDomDocumentFragment fragment  = qdd. createDocumentFragment ();
	fragment . appendChild ( item );
	return fragment;
}

void itemXMLfactory::make(){
	item = qdd.createElement("item");
	QDomElement title_el = qdd.createElement("title");
	item . appendChild (title_el);
	QDomElement content_el = qdd.createElement("content");
	item . appendChild (content_el);
	QDomText titleText = qdd . createTextNode ( title );
	title_el . appendChild (titleText);
	QDomText contentText = qdd . createTextNode ( content );
	content_el . appendChild (contentText);

	if ( pos == end ) {
		item . setAttribute ( "pos", "end" );
	}
	if ( pos == begin ) {
		item . setAttribute ( "pos", "begin" );
	}
	if ( pos == up ) {
		item . setAttribute ( "pos", "up" );
	}
	if ( pos == down ) {
		item . setAttribute ( "pos", "down" );
	}

	if ( type == yellow_type ) {
		item . setAttribute ( "type", "yellow" );
	}
	if ( type == blue_type ) {
		item . setAttribute ( "type", "blue" );
	}
	if ( type == red_type ) {
		item . setAttribute ( "type", "red" );
	}

}

