/***************************************************************************
                          kpreg.cpp  -  description
                             -------------------
    begin                : Seg Jul 30 00:39:14 EDT 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstatusbar.h>

// application specific includes
#include "kpreg.h"
#include "kpregview.h"

#define ID_STATUS_MSG 1

KpregApp::KpregApp(QWidget* , const char* name):KMainWindow(0, name)
{
//	 setMinimumSize ( 260, 388 );
	config=kapp->config();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
	initSysTray ();
	initView();
	initStatusBar();
	initActions();
	initFileDB();
//	initToolBar();
	readOptions();

//	this->centralWidget () -> setMinimumSize ( 260, 388 );

	connect( view, SIGNAL( setSaveButtonEnabled(bool) ), fileSave, SLOT( setEnabled(bool) ) );
	connect( view, SIGNAL( currentCategoryMenu(KPopupMenu*) ), kpst, SLOT( setSubPoupUpMenu(KPopupMenu*) ) );
}

KpregApp::~KpregApp()
{

}

void KpregApp::resizeEvent ( QResizeEvent * /*newSize*/)
{
	view ->resize(
		this -> centralWidget () -> size ().width(),
		this -> centralWidget () ->size().height()
	);
}

void KpregApp::initSysTray()
{
	QString normalPixmap = KGlobal::dirs()->findResource( "data", "kpreg/pen.png" );
//	QPixmap *normalPm = new QPixmap(normalPixmap);
	QPixmap normalPm (normalPixmap);
	kpst = new KpregSysTray ( normalPm, /* _darkerPm,*/ this, "kpst" );
	hierMenu = kpst -> getPoupUpMenu ();
	kpst -> show();

	pAccel = new KGlobalAccel( this );
	pAccel->insert( "Minimise/Restore KPreg", i18n("Minimise/Restore KPreg"),
		i18n("This action allows you to minimise or restore KPreg, same  that to click in System Tray Icon"),
		CTRL+ALT+Key_C, CTRL+ALT+Key_C, kpst, SLOT(minimizeRestore()), true, true );
	pAccel->readSettings();
	pAccel->updateConnections();

}

void KpregApp::initActions()
{
	fileNewWindow = new KAction(i18n("New &Window"), 0, 0, this, SLOT(slotFileNewWindow()), actionCollection(),"file_new_window");
	itemUp = new KAction(i18n("Item &Up"), 0, 0, view, SLOT(moveItemUp()), actionCollection(),"item_up");
	itemDown = new KAction(i18n("Item &Down"), 0, 0, view, SLOT(moveItemDown()), actionCollection(),"item_down");
	categoryRight = new KAction(i18n("Category &Right"), 0, 0, view, SLOT(moveCategoryRight()), actionCollection(),"category_right");
	categoryLeft = new KAction(i18n("Category &Left"), 0, 0, view, SLOT(moveCategoryLeft()), actionCollection(),"category_left");
	newItem = new KAction(i18n("Add &New Item"), 0, 0, this, SLOT(slotAddItem()), actionCollection(),"add_item");
	editItem = new KAction(i18n("&Edit Item"), 0, 0, this, SLOT(slotEditItem()), actionCollection(),"edit_item");
	deleteItem = new KAction(i18n("Delete &Item"), 0, 0, view, SLOT(deleteItem()), actionCollection(),"delete_item");
	newCategory = new KAction(i18n("Add &New Category"), 0, 0, this, SLOT(slotAddCategory()), actionCollection(),"add_category");
	editCategory = new KAction(i18n("&Edit Category Label"), 0, 0, this, SLOT(slotEditCategory()), actionCollection(),"edit_category");
	deleteCategory = new KAction(i18n("&Delete Category and Contents"), 0, 0, view, SLOT(deleteCategory()), actionCollection(),"delete_category");
	fileSave = KStdAction::save(this, SLOT(slotSaveAll()), actionCollection());
	fileSave->setEnabled(false);
	fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
	viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
	viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
//	open = KStdAction::open(this, SLOT(slotFileQuit()), actionCollection());
//	saveAs = KStdAction::saveAs(this, SLOT(slotFileQuit()), actionCollection());
	
	copy = KStdAction::copy(this, SLOT(copyItem()), actionCollection());
	cut = KStdAction::cut(this, SLOT(cutItem()), actionCollection());
	
	/* "Paste" actions: */
	paste_menu = new KActionMenu(i18n("Paste"), "paste_end", actionCollection(),"edit_paste");
	paste_begin = new KAction(i18n("Paste Begin"), 0, 0, this, SLOT(pasteItensBegin()), actionCollection(),"paste_begin");
	paste_end = new KAction(i18n("Paste End"), 0, 0, this, SLOT(pasteItensEnd()), actionCollection(),"paste_end");
	paste_above = new KAction(i18n("Paste Above"), 0, 0, this, SLOT(pasteItensAbove()), actionCollection(),"paste_above");
	paste_below = new KAction(i18n("Paste Below"), 0, 0, this, SLOT(pasteItensBelow()), actionCollection(),"paste_below");
	paste_menu->insert(paste_begin);
	paste_menu->insert(paste_end);
	paste_menu->insert(paste_above);
	paste_menu->insert(paste_below);
	connect( paste_menu, SIGNAL( activated() ), this, SLOT( pasteItensEnd() ) );


	fileNewWindow->setStatusText(i18n("Opens a new KPreg window"));
	fileNewWindow->setIcon("window_new.png");
	itemUp->setStatusText(i18n("Move item up"));
	itemUp->setIcon("1uparrow.png");
	itemDown->setStatusText(i18n("Move item down"));
	itemDown->setIcon("1downarrow.png");
	categoryRight->setStatusText(i18n("Move category to right"));
	categoryRight->setIcon("2rightarrow.png");
	categoryLeft->setStatusText(i18n("Move category to left"));
	categoryLeft->setIcon("2leftarrow.png");
	newItem->setStatusText(i18n("Add new item"));
	newItem->setIcon("editclear.png");
	editItem->setStatusText(i18n("Edit item"));
	editItem->setIcon("edit.png");
	deleteItem->setStatusText(i18n("Delete current item"));
	deleteItem->setIcon("editdelete.png");
	fileQuit->setStatusText(i18n("Quits the KPreg"));
	fileSave->setStatusText(i18n("Save changes"));
	newCategory->setStatusText(i18n("New Category"));
	newCategory->setIcon("tab_new_bg.png");
	editCategory->setStatusText(i18n("Edit Category"));
	editCategory->setIcon("edit.png");
	newCategory->setIcon("tab_new.png");
	deleteCategory->setStatusText(i18n("Delete current Category"));
	deleteCategory->setIcon("tab_remove.png");
	paste_menu->setIcon("editpaste.png");
	viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
	viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  // use the absolute path to your kpregui.rc file for testing purpose in createGUI();
	createGUI();
}

void KpregApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KpregApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.
	view = new KpregView(this);
	view -> setHierMenu(hierMenu);
//	view ->resize( this->size().width(), this->size().height() - 5 );
	setCentralWidget(view);
}

void KpregApp::initFileDB(){

	QDir dir;
	QFile fl;
	QDomDocument xmlDoc ( "mydocument" );

	dir.setPath (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg"));

	if ( !dir.exists () ) {
		dir.mkdir (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg"));
	}

	if ( fl.exists (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml")) ) {
		fl.setName ( operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml") );
		fl.open(IO_ReadOnly);
	}

	if ( !fl.exists (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml")) and fl.exists (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents")) ) {
		importInitFileDB();
		fl.setName (  operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml") );
		fl.open(IO_ReadOnly);
	}

	if ( !fl.exists (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml")) and !fl.exists (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents")) ) {
		fl.setName (  KGlobal::dirs()->findResource( "data", "kpreg/contents_template.xml" ) );
		fl.open(IO_ReadOnly);
	}

	xmlDoc.setContent( &fl );
	fl.close();

	QDomNodeList tabList = xmlDoc . elementsByTagName ( "category" );
	int a = tabList . length ();
	for ( int b=0; b < a; b++ ) {
		view->insertNewTab ( tabList . item ( b ) );
	}
//	hierMenu -> insertSeparator ( hierMenu->count() - 8 );
	hierMenu -> insertSeparator ( 4 );

}

void KpregApp::importInitFileDB(){

	QDomImplementation qdi;
	QDomDocumentType qddt = qdi . createDocumentType ( "kpreg", QString::null, QString::null );
	QDomDocument kpregDoc(qddt);

	QDomElement rootElem = kpregDoc.createElement("kpreg");
	QDomDocumentFragment fragment  = kpregDoc.createDocumentFragment ();
	kpregDoc . appendChild ( rootElem );
	QString qs;

	QDomElement *categElem;
	QDomElement *item;
	QDomElement *title;
	QDomElement *content;
	QDomText *titleText;
	QDomText *contentText;
	categElem = new QDomElement (kpregDoc.createElement("category"));


	QDir dir;
	QFile fl;
	fl.setName (  operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents") );
	fl.open(IO_ReadWrite);
	QTextStream qts ( &fl );
	while ( !qts.eof() ) {
		qs = qts.readLine();
		if ( qs.left (9) == "insertNewTab" ) {
			delete categElem;
			categElem = new QDomElement (kpregDoc.createElement("category"));
			categElem -> setAttribute ( "label", qs.right ( qs. length () - 16 ) );
			fragment.appendChild (*categElem);
		} else {
			if ( qs.isEmpty () == 0 ) {
				if ( qs.left (6) == "[Label" ) {

					item = new QDomElement (kpregDoc.createElement("item"));
					categElem -> appendChild (*item);
					title = new QDomElement (kpregDoc.createElement("title"));
					item -> appendChild (*title);
					content = new QDomElement (kpregDoc.createElement("content"));
					item -> appendChild (*content);
					titleText = new QDomText ( kpregDoc.createTextNode( qs.mid(7, 28).stripWhiteSpace() ) );
					title -> appendChild (*titleText);
					contentText = new QDomText ( kpregDoc.createTextNode(qs.right(qs.length()-36)) );
					content -> appendChild (*contentText);

					if ( qs.left(7) == "[Label="){
						if ( qs.mid(7, 28).stripWhiteSpace().isEmpty() ) {
							item -> setAttribute ( "type", "blue" );
						} else {
							item -> setAttribute ( "type", "red" );
						}
					}
					if ( qs.left (7) == "[Label+") {
						item -> setAttribute ( "type", "yellow" );
					}
					categElem -> appendChild (*item);
					delete item;
					delete title;
					delete content;
					delete titleText;
					delete contentText;

				}
			}
		}
	}
	delete categElem;

	rootElem . appendChild ( fragment );
	fl.close ();

	QFile fl1 ( operator+( dir . homeDirPath (), "/.kde/share/apps/kpreg/contents.xml" ) );
	QTextStream qts1 ( &fl1 );
	fl1 . open( IO_ReadWrite | IO_Append );
	qts1 << kpregDoc . toCString();
	fl1.close ();
}

void KpregApp::saveOptions()
{
  config->setGroup("General Options");
//  config->writeEntry("AutoStart", "true");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
//  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
}


void KpregApp::readOptions()
{

  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
//  toolBar("mainToolBar")->setBarPos(toolBarPos);
  toolBar()->setBarPos(toolBarPos);

  /* initialize the recent file list */
//  fileOpenRecent->loadEntries(config,"Recent Files");

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
}
/*
void KpregApp::saveProperties(KConfig *_cfg)
{
  if(xmlDoc->URL().fileName()!=i18n("Untitled") && !xmlDoc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=xmlDoc->URL();
    _cfg->writeEntry("filename", url.url());
    _cfg->writeEntry("modified", xmlDoc->isModified());
    QString tempname = kapp->tempSaveName(url.url());
    QString tempurl= KURL::encode_string(tempname);
    KURL _url(tempurl);
    xmlDoc->saveDocument(_url);
  }
}


void KpregApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "");
  KURL url(filename);
  bool modified = _cfg->readBoolEntry("modified", false);
  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
    KURL _url(tempname);

    if(canRecover)
    {
      xmlDoc->openDocument(_url);
      xmlDoc->setModified();
      setCaption(_url.fileName(),true);
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      xmlDoc->openDocument(url);
      setCaption(url.fileName(),false);
    }
  }
}
*/
bool KpregApp::queryClose()
{
  return view->saveModified();
}

bool KpregApp::queryExit()
{
	view->setAtSysTray(false);
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KpregApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new KPreg window..."));

  KpregApp *new_window= new KpregApp();
  new_window->show();

  slotStatusMsg(i18n("Ready."));
}
/*
void KpregApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  if(!xmlDoc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {
    xmlDoc->newDocument();
    setCaption(xmlDoc->URL().fileName(), false);
  }

  slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

  if(!xmlDoc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {
    KURL url=KFileDialog::getOpenURL(QString::null,
        i18n("*|All files"), this, i18n("Open File..."));
    if(!url.isEmpty())
    {
      xmlDoc->openDocument(url);
      setCaption(url.fileName(), false);
//      fileOpenRecent->addURL( url );
    }
  }
  slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotFileOpenRecent(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));

  if(!xmlDoc->saveModified())
  {
     // here saving wasn't successful
  }
  else
  {
    xmlDoc->openDocument(url);
    setCaption(url.fileName(), false);
  }

  slotStatusMsg(i18n("Ready."));
}
*/
void KpregApp::slotMenuClicked(int id)
{
	if ( id == 1 ) {
		slotAddItem();
	}
	if ( id == 2 ) {
		view->moveItemUp();
	}
	if ( id == 3 ) {
		view->moveItemDown();
	}
	if ( id == 4 ) {
		slotEditItem();
	}
	if ( id == 5 ) {
		view->deleteItem();
	}
	if ( id == 6 ) {
		slotAddCategory();
	}
	if ( id == 7 ) {
		view->moveCategoryRight();
	}
	if ( id == 8 ) {
		view->moveCategoryLeft();
	}
	if ( id == 9 ) {
		view->pasteItens();
	}
	if ( id == 10 ) {
		view->pasteItens(begin);
	}
	if ( id == 11 ) {
		view->pasteItens(end);
	}
	if ( id == 12 ) {
		view->pasteItens(up);
	}
	if ( id == 13 ) {
		view->pasteItens(down);
	}

}
/*
void KpregApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  KURL url=KFileDialog::getSaveURL(QDir::currentDirPath(),
        i18n("*|All files"), this, i18n("Save as..."));
  if(!url.isEmpty())
  {
    xmlDoc->saveDocument(url);
//    fileOpenRecent->addURL(url);
    setCaption(url.fileName(),xmlDoc->isModified());
  }

  slotStatusMsg(i18n("Ready."));
}
*/
/*
void KpregApp::slotFileClose()
{
	slotStatusMsg(i18n("Closing file..."));
	close();
	slotStatusMsg(i18n("Ready."));
}
*/
/*
void KpregApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n("Ready."));
}
*/
void KpregApp::slotFileQuit()
{
	slotStatusMsg(i18n("Exiting..."));
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KMainWindow* w;
	if(memberList)
	{
		for(w=memberList->first(); w!=0; w=memberList->first())
		{
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
			break;
		}
	}
	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotEditCategory()
{
 	slotStatusMsg(i18n("Altering current category..."));

	Cat_Dialog = new CategoryDialog ( this );
	Cat_Dialog -> setCategory (view->editCategory());
	if (Cat_Dialog->exec() ==  QDialog::Accepted) {
		view->setModified( true );
	}

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotEditItem()
{
	slotStatusMsg(i18n("Altering current item..."));

	Ins_Dialog = new Insert ( this );
	Ins_Dialog -> setItem ( view->editItem() );
	if (Ins_Dialog->exec() ==  QDialog::Accepted) {
		view->setModified( true );
	}

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::copyItem ()
{
	view->copyItem ();
}

void KpregApp::cutItem ()
{
	view->cutItem ();
}

void KpregApp::pasteItensBegin ( )
{
	view->pasteItens (begin);
}

void KpregApp::pasteItensEnd ( )
{
	view->pasteItens (end);
}

void KpregApp::pasteItensAbove ( )
{
	view->pasteItens (up);
}

void KpregApp::pasteItensBelow ( )
{
	view->pasteItens (down);
}

void KpregApp::slotAddItem()
{
	slotStatusMsg(i18n("Inserting new item to list..."));

	Ins_Dialog = new Insert ( this );
	connect( Ins_Dialog, SIGNAL( newItem(QDomDocument) ), view, SLOT( slotAddItem(QDomDocument) ) );
	if (Ins_Dialog->exec() ==  QDialog::Accepted) {
		view->setModified( true );
	}

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotAddCategory()
{
 	slotStatusMsg(i18n("Inserting new category..."));

	Cat_Dialog = new CategoryDialog ( this );
	connect( Cat_Dialog, SIGNAL( newCategory(QDomDocument) ), view, SLOT( insertNewTab(QDomDocument) ) );
	if (Cat_Dialog->exec() ==  QDialog::Accepted) {
		view->setModified( true );
	}

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotSaveAll()
{
	slotStatusMsg(i18n("Was cliked for save all"));

	QDomImplementation qdi;
	QDomDocumentType qddt = qdi . createDocumentType ( "kpreg", QString::null, QString::null );
	QDomDocument kpregDoc(qddt);

	QDomElement rootElem = kpregDoc.createElement("kpreg");
	rootElem . appendChild ( view->save(kpregDoc) );

	kpregDoc . appendChild ( rootElem );

	QDir dir;
	QFile fl ( operator+( dir . homeDirPath (), "/.kde/share/apps/kpreg/contents.xml" ) );
	QTextStream qts ( &fl );
	fl . remove (operator+( dir.homeDirPath (), "/.kde/share/apps/kpreg/contents.xml" ) );
	fl . open( IO_ReadWrite | IO_Append );
	qts << kpregDoc . toCString();

	fl.close ();
	view->setModified( false );
}

void KpregApp::slotViewToolBar()
{
	slotStatusMsg(i18n("Toggling toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if(toolBar()->isVisible())
		toolBar()->hide();
	else
		toolBar()->show();

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotViewStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off
	if(!viewStatusBar->isChecked())
	{
		statusBar()->hide();
	} else {
		statusBar()->show();
	}

	slotStatusMsg(i18n("Ready."));
}

void KpregApp::slotStatusMsg(const QString &text)
{
	///////////////////////////////////////////////////////////////////
	// change status message permanently
	statusBar()->clear();
	statusBar()->changeItem(text, ID_STATUS_MSG);
}



