/***************************************************************************
                          qsoinfo.cpp  -  description
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qsoinfo.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <qfontmetrics.h>
#include <qdatetime.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qlayout.h>
#include <qvbox.h>
#include "globals.h"

#define RADIUS          6370.0

QSOInfo::QSOInfo(QWidget *parent) : KDialogBase (parent, "", false, i18n ("Informations"), 0)
{
	QLabel* l;
	QVBox* vbox = makeVBoxMainWidget();
  QWidget* w = new QWidget (vbox);
	QFontMetrics fm (w->font());

	QGridLayout* grid = new QGridLayout (w, -1, -1, 2, 2);

  l=new QLabel (w);
	l->setText (i18n ("<b>Prefix:</b>"));
	grid->addWidget (l, 0, 0, Qt::AlignRight);
	
	prefixlabel = new QLabel (w);
	prefixlabel->setFixedWidth (fm.width("MMM"));
	grid->addWidget (prefixlabel, 0, 1, Qt::AlignLeft);


  l=new QLabel (w);
	l->setText (i18n ("<b>Country:</b>"));
	grid->addWidget (l, 0, 2, Qt::AlignRight);

	countrylabel = new QLabel (w);
	countrylabel->setFixedWidth (fm.width("MMMMMMMMMMMMM"));
	grid->addMultiCellWidget (countrylabel, 0, 0, 3, 9, Qt::AlignLeft);

  l=new QLabel (w);
	l->setText (i18n ("<b>Continent:</b>"));
	grid->addWidget (l, 1, 0, Qt::AlignRight);

	continentlabel = new QLabel(w);
	continentlabel->setFixedWidth (fm.width("MM"));
	grid->addWidget (continentlabel, 1, 1, Qt::AlignLeft);


  l=new QLabel (w);
	l->setText (i18n ("<b>CQ-Zone:</b>"));
	grid->addWidget (l, 1, 2, Qt::AlignRight);

	cq_zonelabel = new QLabel(w);
	cq_zonelabel->setFixedWidth (fm.width("MM"));
	grid->addWidget (cq_zonelabel, 1, 3, Qt::AlignLeft);

  l=new QLabel (w);
	l->setText (i18n ("<b>ITU-Zone:</b>"));
	grid->addWidget (l, 1, 4, Qt::AlignLeft);

	itu_zonelabel = new QLabel(w);
	itu_zonelabel->setFixedWidth (fm.width("MM"));
	grid->addWidget (itu_zonelabel, 1, 5, Qt::AlignLeft);

  l=new QLabel (w);
	l->setText (i18n ("<b>Direction:</b>"));
	grid->addWidget (l, 2, 0, Qt::AlignRight);

	directionlabel = new QLabel(w);
	directionlabel->setFixedWidth (fm.width("999"));
	grid->addWidget (directionlabel, 2, 1, Qt::AlignLeft);

  l=new QLabel (w);
	l->setText (i18n ("<b>Distance:</b>"));
	grid->addWidget (l, 2, 2, Qt::AlignRight);

	distancelabel = new QLabel(w);
	distancelabel->setFixedWidth (fm.width("99999 Km"));
	grid->addMultiCellWidget (distancelabel, 2, 2, 3, 3, Qt::AlignLeft);

  l=new QLabel(w);
  l->setText (i18n ("<b>Time:</b>"));
  grid->addWidget (l, 2, 4, Qt::AlignRight);

  timelabel = new QLabel(w);
  timelabel->setFixedWidth (fm.width("24:00"));
  grid->addWidget (timelabel, 2, 5, Qt::AlignLeft);

	infoview = new QListView (vbox);
	infoview->setAllColumnsShowFocus (true);
	infoview->setSorting(-1);

	infoview->addColumn (i18n ("Send"), fm.width("MMMM"));
	infoview->addColumn (i18n ("Rcvd"), fm.width("MMMM"));
	infoview->addColumn (i18n ("Date"), fm.width("MMM.MM.MM"));
	infoview->addColumn (i18n ("Time"), fm.width("MM:MM:"));
	infoview->addColumn (i18n ("Band"), fm.width("MMMMM"));
	infoview->setColumnAlignment (0, Qt::AlignHCenter);
	infoview->setColumnAlignment (1, Qt::AlignHCenter);
	infoview->setColumnAlignment (2, Qt::AlignHCenter);
	infoview->setColumnAlignment (3, Qt::AlignHCenter);
	infoview->setColumnAlignment (4, Qt::AlignHCenter);
	infoview->setFixedHeight (100);
	QObject::connect (this, SIGNAL (hidden()), this, SLOT (slotBye()));

	timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotUpdateTime()));
}

QSOInfo::~QSOInfo()
{
}

void QSOInfo::insertQSO (QString rsts, QString rstr, QString date, QString time, QString band)
{
	QListViewItem* list = new QListViewItem (infoview);
	list->setText (0, rsts);
	list->setText (1, rstr);
	list->setText (2, date);
	list->setText (3, time);
	list->setText (4, band);
}

void QSOInfo::clearqso()
{
	infoview->clear();
	clearInfo();
}

void QSOInfo::setInfo (s_dxcc _dxcc)
{
	prefix="";
	country="";
	continent="";
	itu_zone="";
	cq_zone="";
  time_zone="";
	distance="";
	direction="";

	if (_dxcc.cq == -1) {
		displayInfo();
		return;
	}

		prefix = _dxcc.prefix;
		country = _dxcc.country;
		continent = _dxcc.continent;
		itu_zone = QString::number(_dxcc.itu);
		cq_zone = QString::number(_dxcc.cq);		
    timediff = (int) (_dxcc.timezone * -3600.0);
		hislatitude = (long) (_dxcc.latitude * 3600.0);
		hislongitude = (long) (_dxcc.longitude * 3600.0);
  	loc_to_sec (config.personals.loc.latin1(), &mylongitude, &mylatitude);
  	calculate (&distance, &direction);
  	slotUpdateTime();
		displayInfo();
}

void QSOInfo::clearInfo ()
{
	prefix="";
	country="";
	continent="";
	itu_zone="";
	cq_zone="";
  time_zone="";
	distance="";
	direction="";

	displayInfo();
}


void QSOInfo::displayInfo()
{
	countrylabel->setText (country);
	prefixlabel->setText (prefix);
	continentlabel->setText (continent);
	itu_zonelabel->setText (itu_zone);
	cq_zonelabel->setText (cq_zone);
	distancelabel->setText (distance);
	directionlabel->setText (direction);
	if (country == "") {
		timer->stop();
		timelabel->setText ("");
  }
  else
		timer->start (1000, false);
}

double QSOInfo::safe_acos(double a)
{
  if (a >=  1.0) return 0;
  if (a <= -1.0) return M_PI;
  return acos(a);
}

double QSOInfo::norm_course(double a)
{
  while (a <    0.0) a += 360.0;
  while (a >= 360.0) a -= 360.0;
  return a;
}

void QSOInfo::loc_to_sec(const char* loc, long *longitude, long *latitude)
{
  *longitude =  180 * 3600L
	       - 20 * 3600L * (loc[0] - 'A')
	       -  2 * 3600L * (loc[2] - '0')
	       -  5 *   60L * (loc[4] - 'A')
	       -       150L;

  *latitude  = - 90 * 3600L
	       + 10 * 3600L * (loc[1] - 'A')
	       +      3600L * (loc[3] - '0')
	       +       150L * (loc[5] - 'A')
	       +        75L;
}


void QSOInfo::calculate(QString* dist, QString* dir)
{
  double a1;
  double a2;
  double b1;
  double b2;
  double e;
  double l1;
  double l2;

  l1 = mylongitude / 648000.0 * M_PI;
  l2 = hislongitude / 648000.0 * M_PI;
  b1 = mylatitude  / 648000.0 * M_PI;
  b2 = hislatitude  / 648000.0 * M_PI;

  e = safe_acos(sin(b1) * sin(b2) + cos(b1) * cos(b2) * cos(l2-l1));

	*dist = QString::number (e*RADIUS, 'f', 0) + " Km";

  a1 = safe_acos((sin(b2) - sin(b1) * cos(e)) / sin(e) / cos(b1)) / M_PI * 180.0;
  a2 = safe_acos((sin(b1) - sin(b2) * cos(e)) / sin(e) / cos(b2)) / M_PI * 180.0;
  if (l2 > l1) a1 = 360.0 - a1;
  if (l1 > l2) a2 = 360.0 - a2;
  a1 = norm_course(a1);
  a2 = norm_course(a2);

	*dir = QString::number (a1, 'f', 0) + "";
}

void QSOInfo::slotBye()
{
	kpsk->uncheckQsoInfoMenu();
}

void QSOInfo::slotUpdateTime()
{
	QTime time;
	QString min, hr;

	char _min[10];
	char _hour[10];
	time_t t;
	struct tm* mytime;

	t = ::time(0);
	mytime = gmtime (&t);
  strftime (_min, 9, "%M", mytime);
  strftime (_hour, 9, "%H", mytime);

	time = QTime (atoi (_hour), atoi (_min), 0);
  time = time.addSecs (timediff);

	min = QString::number(time.minute());
	if (time.minute() < 10)
    min = "0"+min;
  hr  = QString::number(time.hour());

  timelabel->setText(hr+":"+min);
}
